package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
* @Author: aiqinguo
* @Description: 磅单审核表
* @Date: 2023/09/19 13:16:57
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class OrderChildPoundAudit implements HasKey<Integer> {

    private Integer id;                             //id
    private String childNo;                         //运单编号
    private Integer status;                         //审核状态
    private Integer rejectType;                     //审核驳回类型：1装车 2卸车 3装车+卸车
    private String remark;                          //备注
    private String createTime;                      //创建时间
    private String modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}