package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class OrderChild implements HasKey<Integer> {

    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private Long ownerUserNo;                       //货主用户编号
    private String childNo;                         //运单编号
    private String orderGoodsNo;                    //货单编号
    private String orderNo;                         //订单编号

    private Integer goodsId;                        //货物id
    private String goodsName;                       //货物名称
    private BigDecimal freightPrice;                //运费单价（分）

    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private Integer truckId;                        //车辆ID
    private String truckNo;                         //车牌号
    private BigDecimal truckLoad;                   //载重（单位吨）
    private Long driverUserNo;                      //司机用户编号
    private String driverName;                      //司机姓名
    private String driverMobile;                    //司机手机号

    private BigDecimal loadRough;                   //装货毛重（单位吨）
    private BigDecimal loadTare;                    //装货皮重（单位吨）
    private BigDecimal loadNet;                     //装货净重（单位吨）
    private BigDecimal unloadRough;                 //卸货毛重（单位吨）
    private BigDecimal unloadTare;                  //卸货皮重（单位吨）
    private BigDecimal unloadNet;                   //卸货净重（单位吨）
    private BigDecimal weight;                      //拉运重量（单位吨）

    private Integer poundStatus;                    //磅单审核状态
    private Integer status;                         //状态

    private LocalDateTime payTime;                         //支付时间
    private LocalDateTime loadTime;                        //装车时间
    private LocalDateTime unloadTime;                      //卸车时间
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}