package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.mapper.OrderChildMapper;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.pc.OrderChildPoundAuditVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildDaoImpl extends BaseDaoImpl<OrderChildMapper, OrderChild, Integer> implements OrderChildDao {
    @Override
    public boolean updateCancel(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateLoad(OrderChild item) {
        return false;
    }

    @Override
    public boolean updateUnload(OrderChild item) {
        return false;
    }

    @Override
    public boolean updateLoadAndUnload(OrderChild item) {
        return false;
    }

    @Override
    public boolean updateDriverConfirm(OrderChild item) {
        return false;
    }

    @Override
    public Optional<OrderChild> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(OrderChild::getChildNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public long countOfCancel(Long userNo, LocalDateTime startTime, LocalDateTime endTime) {

        return count(lQrWrapper()
                .eq(OrderChild::getChildNo, userNo)
                .eq(OrderChild::getStatus, OrderChildEnum.Status.DRIVER_CANCEL.getCode())
                .ge(OrderChild::getCreateTime, startTime)
                .le(OrderChild::getCreateTime, endTime)
        );
    }

    @Override
    public IPage<OrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param) {
        Page<OrderChildPoundAuditVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pagePoundAuditList(page,param);
    }
}
