package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.OrderChildMapper;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.pc.OrderChildPoundAuditVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.time.LocalDateTime;

/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
public interface OrderChildDao extends BaseDao<OrderChildMapper, OrderChild, Integer> {

    boolean updateCancel(OrderChild item);
    boolean updateLoad(OrderChild item);
    boolean updateUnload(OrderChild item);
    boolean updateLoadAndUnload(OrderChild item);
    boolean updateDriverConfirm(OrderChild item);


    Optional<OrderChild> getByChildNo(String childNo);

    long countOfCancel(Long userNo, LocalDateTime startTime, LocalDateTime endTime);

    IPage<OrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param);


}
