package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.vo.pc.OrderChildPoundAuditVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/poundaudit")
@Validated
@Api(tags = "承运端-运单")
@AllArgsConstructor
public class OrderChildPoundAuditController {

    private final OrderChildService orderChildService;

    @ApiOperation(value = "磅单审核列表",notes = "<br>By:李瑞新")
    @PostMapping("/pagePoundAuditList")
    public Result<PageData<OrderChildPoundAuditVO>> pagePoundAuditList(@RequestBody PagePoundAuditParam param) {
        IPage<OrderChildPoundAuditVO> page = orderChildService.pagePoundAuditList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
}
