package com.clx.performance.component;

import com.clx.performance.dao.OrderGoodsDao;
import com.msl.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

@Component
public class OrderGoodsIdGenerate {

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private OrderGoodsDao orderGoodsDao;



    public int getOrderGoodsId(String type, Integer size) {
        int baseStart = Integer.parseInt(DateUtils.formatDate(LocalDate.now(), "yyyyMMdd") + "00001");
        Object o = redisTemplate.opsForHash().get("performance:orderGoodsId:", type);
        if (o == null) {
            int maxOrderGoodsId = orderGoodsDao.getMaxOrderGoodsId(type);
            if (baseStart > maxOrderGoodsId) {
                redisTemplate.opsForHash().put("performance:orderGoodsId:", type, baseStart + size);
                return baseStart;
            } else {
                int orderGoodsId = maxOrderGoodsId + 1;
                redisTemplate.opsForHash().put("performance:orderGoodsId:", type, orderGoodsId + size);
                return orderGoodsId;
            }
        } else {
            int redisOrderGoodsId = Integer.parseInt(o.toString());
            int orderGoodsId = redisOrderGoodsId + 1;
            redisTemplate.opsForHash().put("performance:orderGoodsId:", type, orderGoodsId + size);
            return orderGoodsId;
        }
    }
}
