package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class OrderChildPoundAuditVO  {

    @ApiModelProperty(value="运单编号",example = "41441")
    private String childNo;

    @ApiModelProperty(value="货物名称",example = "煤炭")
    private String goodsName;

    @ApiModelProperty(value="发货地址",example = "吉林")
    private String sendAddress;

    @ApiModelProperty(value="收货地址",example = "山西")
    private String receiveAddress;

    @ApiModelProperty(value="司机姓名",example = "张安")
    private String driverName;

    @ApiModelProperty(value="司机手机号",example = "12222222222")
    private String driverMobile;

    @ApiModelProperty(value="装货净重",example = "10")
    private BigDecimal loadNet;

    @ApiModelProperty(value="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @ApiModelProperty(value="审核状态 0-待审核，1-审核失败， 2-审核成功",example = "1")
    private Integer status;

    @ApiModelProperty(value="接单时间",example = "2020-01-01 10:10:10")
    private String payTime;

    @ApiModelProperty(value="装车时间",example = "2020-01-01 10:10:10")
    private String loadTime;

    @ApiModelProperty(value="卸车时间",example = "2020-01-01 10:10:10")
    private String unloadTime;




}