package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildLogEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        CREATED(1, "接单成功"),

        GO_TO_SEND(3, "前往货源地"),
        ARRIVE_SEND(4, "到达货源地"),
        GO_TO_RECEIVE(5, "前往目的地"),
        ARRIVE_RECEIVE(6 , "到达目的地"),
        POUND_AUDIT(7, "磅单审核"),

        LOAD(11, "提交装货信息"),
        UNLOAD(12, "提交卸货信息"),
        RELOAD(13, "修改装货信息"),
        REUNLOAD(14, "修改卸货信息"),
        RELOAD_AND_REUNLOAD(15, "修改装货、卸货信息"),

        DRIVER_CONFIRM(21, "司机确认收货"),
        COMPLETE(21, "完成"),

        DRIVER_CANCEL(31, "司机取消运单"),
        OWNER_CANCEL(32, "货主取消运单"),

        ;

        private final int code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
