package com.clx.order.params;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PageCarrierOrderListParam extends PageParam {

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "联系人(货主)id")
    private Integer contactId;

    @ApiModelProperty(value="订单状态：2报价已确认 3平台已承接  7 挂单中 8运输中")
    private Integer orderStatus;

    @ApiModelProperty(value = "开始时间",example = "2023-09-09 12:00:01" ,required = true)
    private String beginTime;

    @ApiModelProperty(value = "结束",example = "2023-09-09 12:00:01" ,required = true)
    private String endTime;

    @ApiModelProperty(value="时间类型： 1创建时间 2拉运开始时间 3拉运结束时间 ")
    @NotNull(message = "时间类型不能为空")
    private Integer timeType;

    @ApiModelProperty(value="用车类型： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;

}
