package com.clx.order.common;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-09-09
 * Time 10:48
 */
@Data
public class OrderInfo{

    private Integer id;

    @ApiModelProperty(value = "货主用户编号")
    private Long ownerUserNo;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "剩余吨数")
    private BigDecimal residueWeight;

    @ApiModelProperty(value = "拉运类型 0单次拉运 1长期拉运")
    private Integer transportType;

    @ApiModelProperty(value = "长协合同编号")
    private String longTermContractNo;

    @ApiModelProperty(value = "货物类型编码")
    private String goodsTypeCode;

    @ApiModelProperty(value = "货物类型名称")
    private String goodsTypeName;

    @ApiModelProperty(value = "货物名称")
    private String goodsName;

    @ApiModelProperty(value = "货物型号")
    private String goodsModel;

    @ApiModelProperty(value = "拉运重量（吨）")
    private BigDecimal transportWeight;

    @ApiModelProperty(value = "向下浮动量（吨）")
    private BigDecimal downFloatWeight;

    @ApiModelProperty(value = "向上浮动量（吨）")
    private BigDecimal upFloatWeight;

    @ApiModelProperty(value = "是否可超吨 0 否  1 是")
    private Integer overWeight;

    @ApiModelProperty(value = "损耗单价(元)")
    private BigDecimal lossPrice;

    @ApiModelProperty(value = "联系人id（货主方）")
    private Integer contactId;

    @ApiModelProperty(value = "联系人（货主方）")
    private String contactOwner;

    @ApiModelProperty(value = "联系电话（货主方)")
    private String contactPhoneOwner;

    @ApiModelProperty(value = "发货-地址id")
    private Integer sendAddressId;

    @ApiModelProperty(value = "发货-地址简称")
    private String sendAddressShorter;

    @ApiModelProperty(value = "发货-场地类型id")
    private Integer sendSiteTypeId;

    @ApiModelProperty(value = "发货-场地类型")
    private String sendSiteType;

    @ApiModelProperty(value = "发货-是否可超标准  0 否  1 是")
    private Integer sendOverStandard;

    @ApiModelProperty(value = "发货-预估装车时长(小时)")
    private BigDecimal sendEstimatedLoadingTime;

    @ApiModelProperty(value = "发货-是否需要系统排队 0 否  1 是")
    private Integer sendWaitSystem;

    @ApiModelProperty(value = "发货-排队系统名称")
    private String sendWaitSystemName;

    @ApiModelProperty("发货-预估排队时长")
    private BigDecimal sendEstimatedWaitTime;

    @ApiModelProperty("发货-煤源生产情况 1 现产现装  2 存煤")
    private Integer sendCoalSourceProductSituation;

    @ApiModelProperty("发货-现产现装效率(车/小时)")
    private BigDecimal sendProductLoadEfficiency;

    @ApiModelProperty("发货-司机到达货源地范围(千米)")
    private BigDecimal sendDriverArriveRange;

    @ApiModelProperty("发货-过磅费(元)")
    private BigDecimal sendPoundFee;

    @ApiModelProperty("发货-其他过磅费(元)")
    private BigDecimal sendOtherPoundFee;

    @ApiModelProperty("发货-装卸费(元)")
    private BigDecimal sendLoadFee;

    @ApiModelProperty("发货-其他装卸费(元)")
    private BigDecimal sendOtherLoadFee;

    @ApiModelProperty("发货-其他费用  数据样例： [{'fee':500,'remark':'其他费用备注'}]")
    private String sendOtherFee;

    @ApiModelProperty("发货-货源地开支金额起")
    private BigDecimal sendPayFeeBegin;

    @ApiModelProperty("发货-货源地开支金额止")
    private BigDecimal sendPayFeeEnd;

    @ApiModelProperty("收货-地址id")
    private Integer reveiveAddressId;

    @ApiModelProperty("收货-地址简称")
    private String reveiveAddressShorter;

    @ApiModelProperty("收货-场地类型id")
    private Integer reveiveSiteTypeId;

    @ApiModelProperty("收货-场地类型")
    private String reveiveSiteType;

    @ApiModelProperty("收货-是否可超标准  0 否  1 是")
    private Integer reveiveOverStandard;

    @ApiModelProperty("收货-预估装车时长(小时)")
    private BigDecimal reveiveEstimatedLoadingTime;

    @ApiModelProperty("收货-是否需要系统排队 0 否  1 是")
    private Integer reveiveWaitSystem;

    @ApiModelProperty("收货-排队系统名称")
    private String reveiveWaitSystemName;

    @ApiModelProperty("收货-司机到达目的地范围(千米)")
    private BigDecimal reveiveDriverArriveRange;

    @ApiModelProperty("收发地磅差")
    private BigDecimal reveivePoundDiff;

    @ApiModelProperty("收货-过磅费(元)")
    private BigDecimal reveivePoundFee;

    @ApiModelProperty("收货-其他过磅费(元)")
    private BigDecimal reveiveOtherPoundFee;

    @ApiModelProperty("收货-装卸费(元)")
    private BigDecimal reveiveLoadFee;

    @ApiModelProperty("收货-其他装卸费(元)")
    private BigDecimal reveiveOtherLoadFee;

    @ApiModelProperty("收货-其他费用  数据样例： [{'fee':500,'remark':'其他费用备注'}]")
    private String reveiveOtherFee;

    @ApiModelProperty("收货-收货地开支金额起")
    private BigDecimal reveivePayFeeBegin;

    @ApiModelProperty("收货-收货地开支金额止")
    private BigDecimal reveivePayFeeEnd;

    @ApiModelProperty("用车需求： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;

    @ApiModelProperty("平台承运吨数")
    private BigDecimal platformCarryWeight;

    @ApiModelProperty("自有车辆(辆)")
    private Integer ownerTruckNumber;

    @ApiModelProperty("车型要求数组")
    private String truckModelList;

    @ApiModelProperty("拉运开始时间")
    private LocalDateTime transportBeginTime;

    @ApiModelProperty("拉运结束时间")
    private LocalDateTime transportEndTime;

    @ApiModelProperty("可装车时间段开始")
    private String loadBeginTime;

    @ApiModelProperty("可装车时间段结束")
    private String loadEndTime;

    @ApiModelProperty("可卸车时间段开始")
    private String unloadBeginTime;

    @ApiModelProperty("可卸车时间段结束")
    private String unloadEndTime;

    @ApiModelProperty("意向运费")
    private BigDecimal intentionFreightPrice;


    @ApiModelProperty("有效运费")
    private BigDecimal validFreightPrice;




    @ApiModelProperty("订单状态： 0待报价 1客户确认中 2报价已确认 3平台已承接 4已取消 5暂停 6拒绝承运 7 挂单中 8运输中 9订单已完成 10 已失效")
    private Integer orderStatus;

    @ApiModelProperty("报价状态：2确认报价  3驳回报价")
    private Integer quotationStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

}
