package com.clx.performance.service.impl.breakcontract;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.breakcontract.BreakContractOwnerRuleDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.breakcontract.BreakContractOwnerRule;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleStatusUpdateParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRuleParam;
import com.clx.performance.service.breakcontract.BreakContractMqService;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.clx.performance.struct.breakcontract.BreakContractOwnerRuleStruct;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleFileVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRulePullDownVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import com.msl.common.exception.ServiceSystemException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
public class BreakContractOwnerRuleServiceImpl  implements BreakContractOwnerRuleService {


    @Autowired
    private BreakContractOwnerRuleDao breakContractOwnerRuleDao;
    @Autowired
    private BreakContractOwnerRuleStruct breakContractOwnerRuleStruct;
    @Autowired
    private BreakContractMqService breakContractMqService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveRule(BreakContractOwnerRuleAddParam param) {

        BreakContractOwnerRule rule = breakContractOwnerRuleDao.selectByName(param.getName()).orNull();
        if (rule != null) {throw new ServiceSystemException(PerformanceResultEnum.BREAK_CONTRACT_RULE_NAME_EXIST);}

        rule = new BreakContractOwnerRule();
        rule.setName(param.getName());
        rule.setRuleJson(JSON.toJSONString(param.getRule()));

        BreakContractOwnerRuleVO.AutoRule autoRule = new BreakContractOwnerRuleVO.AutoRule();
        autoRule.setOrderCancelRule(new BreakContractOwnerRuleVO.OrderCancelRule());
        autoRule.setOrderAmountReduceRule(new BreakContractOwnerRuleVO.OrderAmountReduceRule());

        autoRule.getOrderAmountReduceRule().setBeforeRatio(new BigDecimal(param.getRule().get("A-a")).movePointLeft(2));
        autoRule.getOrderAmountReduceRule().setAfterRatio(new BigDecimal(param.getRule().get("A-b")).movePointLeft(2));
        autoRule.getOrderCancelRule().setBeforeRatio(new BigDecimal(param.getRule().get("A-c")).movePointLeft(2));
        autoRule.getOrderCancelRule().setAfterRatio(new BigDecimal(param.getRule().get("A-d")).movePointLeft(2));
        autoRule.getOrderCancelRule().setAfterFigurePerHour(new BigDecimal(param.getRule().get("A-e")).movePointLeft(2));
        rule.setAutoRuleJson(JSON.toJSONString(autoRule));

        breakContractOwnerRuleDao.saveEntity(rule);

        breakContractMqService.ownerRuleAdd(rule.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateStatus(BreakContractOwnerRuleStatusUpdateParam param) {
        BreakContractOwnerRule rule = breakContractOwnerRuleDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.BREAK_CONTRACT_RULE_NO_FOUND);

        rule.setStatus(param.getStatus());
        breakContractOwnerRuleDao.updateRuleStatus(rule);

    }

    @Override
    public BreakContractOwnerRuleVO getRuleInfo(Integer id) {
        BreakContractOwnerRule rule = breakContractOwnerRuleDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.BREAK_CONTRACT_RULE_NO_FOUND);

        BreakContractOwnerRuleVO vo = new BreakContractOwnerRuleVO();
        vo.setId(rule.getId());
        vo.setName(rule.getName());
        vo.setRule(JSON.parseObject(rule.getRuleJson(), Map.class));
        vo.setStatus(rule.getStatus());

        return vo;
    }

    @Override
    public BreakContractOwnerRuleFileVO getRuleFile(Integer id) {
        BreakContractOwnerRule rule = breakContractOwnerRuleDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.BREAK_CONTRACT_RULE_NO_FOUND);

        BreakContractOwnerRuleFileVO vo = new BreakContractOwnerRuleFileVO();
        vo.setId(rule.getId());
        vo.setName(rule.getName());
        vo.setFile(rule.getFile());

        return vo;
    }

    @Override
    public IPage<BreakContractOwnerRuleVO> pageRule(PageBreakContractOwnerRuleParam param) {
        return breakContractOwnerRuleDao.pageByParam(param);

    }

    @Override
    public List<BreakContractOwnerRulePullDownVO> listPullDown() {
        return breakContractOwnerRuleStruct.convertBreakContractOwnerRulePullDownVO(breakContractOwnerRuleDao.listEnable());
    }

}
