package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.clx.open.sdk.callback.OpenCallBackClient;
import com.clx.open.sdk.callback.message.OrderChildMessage;
import com.clx.open.sdk.enums.ResultStatusEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.config.MslAppConfig;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dto.dts.DataTransportDTO;
import com.clx.performance.enums.DtsOperationTypeEnum;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.msl.common.result.Result;
import com.msl.common.utils.DtsMapConvertUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Objects;


@Slf4j
@Component
@AllArgsConstructor
public class OrderChildDtsListener  {
    @Autowired
    private final MslAppConfig mslAppConfig;


    @Autowired
    private OrderFeign orderFeign;
    @Autowired
    private OrderGoodsDao orderGoodsDao;
    @Autowired
    private  OrderChildDao orderChildDao;

    @RabbitListener(queues = RabbitKeyConstants.CLX_PERFORMANCE_ORDER_CHILD_QUEUE)
    public void onMessage(Message message) {
        try {
            String msg = new String(message.getBody());
            log.info("DTS消息同步开始, database:clx_performance.order_child, msg:{}", msg);

            DataTransportDTO dataTransportDTO = JSON.parseObject(msg, DataTransportDTO.class);

            OrderChildMessage before = DtsMapConvertUtil.convert(dataTransportDTO.getBeforeMap(), new OrderChildMessage());
            OrderChildMessage after = DtsMapConvertUtil.convert(dataTransportDTO.getAfterMap(), new OrderChildMessage());

            if(Objects.equals(DtsOperationTypeEnum.INSERT.getCode(),dataTransportDTO.getOperationType().getCode())){
                //同步after数据
                log.info("新增:{}"+after);
//                OpenCallBackClient client = new OpenCallBackClient(mslAppConfig.getUrl(),mslAppConfig.getAppId(),mslAppConfig.getSecret());
//                Result result = client.encryptPost(JSON.toJSONString(after),after.topic());
//                log.info("响应结果:{}",JSON.toJSONString(result));

            }else if(Objects.equals(DtsOperationTypeEnum.UPDATE.getCode(),dataTransportDTO.getOperationType().getCode())){
                log.info("修改:{}"+after);
                if(OrderChildEnum.SYNC_STATUS_lIST.contains(after.getStatus()) && !Objects.equals(before.getStatus(),after.getStatus())){
                    //同步after数据

                    orderChildChangeAfter(after);
                }
            }else if(Objects.equals(DtsOperationTypeEnum.DELETE.getCode(),dataTransportDTO.getOperationType().getCode())){
                //数据删除
                log.info("删除:{}"+before);

            }


        } catch (Exception e) {
            log.info("DTS消息同步失败, database:clx_performance.order_child, error:{}", e.getMessage());
        }
    }

    public void orderChildChangeAfter(OrderChildMessage after){
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(after.getOrderNo());
        if (orderInfoFeign == null) {
            return;
        }
        after.setLastFlag(ResultStatusEnum.NO.getCode());
        long nowTimeMillis = System.currentTimeMillis();
        LocalDateTime nowDateTime = new Date(nowTimeMillis).toInstant().atOffset(ZoneOffset.of("+8")).toLocalDateTime();
        //如果当前货单已完成，则判断之前所有货单是否等于订单总吨数，等于则更新订单为已完成
        List<OrderGoods> list = orderGoodsDao.getOrderGoodsListByOrderNoAndLastArriveSendTime(after.getOrderNo(), nowDateTime);
        BigDecimal childSum = list.stream().map(OrderGoods::getExtractWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("算出所有货单总量:{}, 订单总吨数：{}", childSum, orderInfoFeign.getTransportWeight());
        if (childSum.compareTo(orderInfoFeign.getTransportWeight()) == 0) {
            // 按照时间 倒序查出最后一条进行中的运单
            OrderChild orderChild = orderChildDao.getGoingLatestOrderChildByOrderNo(after.getOrderNo());
            if(Objects.nonNull(orderChild) && orderChild.getChildNo().equals(after.getChildNo())){
                after.setLastFlag(ResultStatusEnum.YES.getCode());
            }
        }
        OpenCallBackClient client = new OpenCallBackClient(mslAppConfig.getUrl(),mslAppConfig.getAppId(),mslAppConfig.getSecret());
        Result result = client.encryptPost(JSON.toJSONString(after),after.topic());
        log.info("订单信息同步，运单编号:{},响应结果:{}",after.getChildNo(),JSON.toJSONString(result));

    }

}
