package com.clx.performance.struct.breakcontract;

import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {BreakContractSettlementDriverEnum.class,  DateUtils.class})
public interface BreakContractSettlementDriverStruct {


    @Named("toBaseVo")
    @Mapping(target = "settleStatusMsg", expression = "java(BreakContractSettlementDriverEnum.SettleStatus.getMsgByCode(detail.getSettleStatus()))")
    @Mapping(target = "settlePlatformMsg", expression = "java(BreakContractSettlementDriverEnum.SettlePlatform.getMsgByCode(detail.getSettlePlatform()))")
    @Mapping(target = "breakContractPartyTypeMsg", expression = "java(BreakContractSettlementDriverEnum.BreachContractPartyType.getMsgByCode(detail.getBreakContractPartyType()))")
    PageCarrierBreakContractSettlementDriverVO convert(BreakContractSettlementDriver detail);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<PageCarrierBreakContractSettlementDriverVO> covertToCarrierList(List<BreakContractSettlementDriver> list);

}
