package com.clx.performance.service.impl.breakcontract;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementOwnerDao;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwner;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.clx.performance.struct.breakcontract.BreakContractSettlementOwnerStruct;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class BreakContractSettlementOwnerServiceImpl  implements BreakContractSettlementOwnerService {

    private final BreakContractSettlementOwnerDao breakContractSettlementOwnerDao;
    private final BreakContractSettlementOwnerStruct breakContractSettlementOwnerStruct;

    @Override
    public IPage<PageCarrierBreakContractSettlementOwnerVO> pageCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param) {
        IPage<BreakContractSettlementOwner> breakContractSettlementDriverDetail = breakContractSettlementOwnerDao.pageCarrierBreakContractSettlementOwnerList(param);
        List<PageCarrierBreakContractSettlementOwnerVO> list = breakContractSettlementOwnerStruct.covertToCarrierList(breakContractSettlementDriverDetail.getRecords());
        return new Page<PageCarrierBreakContractSettlementOwnerVO>().setRecords(list).setTotal(breakContractSettlementDriverDetail.getTotal()).setPages(breakContractSettlementDriverDetail.getPages());

    }

    @Override
    public SXSSFWorkbook exportCarrierBreakContractSettlementOwnerList(PageCarrierBreakContractSettlementOwnerParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        IPage<PageCarrierBreakContractSettlementOwnerVO> settlementOwnerDetail = pageCarrierBreakContractSettlementOwnerList(param);

        List<PageCarrierBreakContractSettlementOwnerVO> list = settlementOwnerDetail.getRecords();

        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(2, "货主编号", "ownUserNo", 5000));
        fieldList.add(new ExcelField(3, "货主名称", "ownerName", 5000));

        fieldList.add(new ExcelField(4, "违约方", "breachContractPartyType", 5000));
        fieldList.add(new ExcelField(5, "违约金额", "figure", 5000));
        fieldList.add(new ExcelField(6, "状态", "statusMsg", 5000));
        fieldList.add(new ExcelField(7, "结算单号", "settlementNo", 5000));
        fieldList.add(new ExcelField(8, "创建人", "createName", 5000));
        fieldList.add(new ExcelField(9, "创建时间", "createTime", 5000));



        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            PageCarrierBreakContractSettlementOwnerVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getOwnerUserNo()+""));
            rowData.add(new ExcelData(dto.getOwnerName()));

            rowData.add(new ExcelData(dto.getBreakContractPartyTypeMsg()));
            rowData.add(new ExcelData(dto.getFigure().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getStatusMsg()));
            rowData.add(new ExcelData(dto.getSettlementNo()));
            rowData.add(new ExcelData(dto.getCreateName()));
            rowData.add(new ExcelData(dto.getCreateTime()));


            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("货主违约结算单", "货主违约结算单", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }
}
