package com.clx.performance.service.impl.breakcontract;


import com.clx.performance.dao.breakcontract.BreakContractOwnerRecordDao;
import com.clx.performance.enums.BreakContractRecordEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.extranal.user.OrderService;
import com.clx.performance.model.breakcontract.BreakContractOwnerRecord;
import com.clx.performance.param.pc.breakcontract.BreakContractOwnerRecordAddParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
public class BreakContractOwnerRecordServiceImpl  implements BreakContractOwnerRecordService {

    @Autowired
    private BreakContractOwnerRecordDao breakContractOwnerRecordDao;

    @Autowired
    private OrderService orderService;


    @Override
    public void saveRecord(BreakContractOwnerRecordAddParam param) {
        orderService.getOrderInfo(param.getOrderNo()).orElseThrow(PerformanceResultEnum.ORDER_NO_FOUND);

        BreakContractOwnerRecord record = new BreakContractOwnerRecord();

        record.setTriggerType(BreakContractRecordEnum.TriggerType.MANUAL.getCode());
        record.setBreachContractPartyType(param.getBreachContractPartyType());
        record.setBreachContractPartyType(param.getBreachContractPartyType());
        record.setOrderNo(param.getOrderNo());
        record.setFigure(param.getFigure());
        record.setRemark(param.getRemark());

        breakContractOwnerRecordDao.saveEntity(record);
    }
}
