package com.clx.performance.service.impl.breakcontract;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.breakcontract.BreakContractDriverRecordDao;
import com.clx.performance.enums.BreakContractRecordEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.breakcontract.BreakContractDriverRecord;
import com.clx.performance.param.pc.breakcontract.BreakContractDriverRecordAddParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
public class BreakContractDriverRecordServiceImpl  implements BreakContractDriverRecordService {

    @Autowired
    private BreakContractDriverRecordDao breakContractDriverRecordDao;
    @Autowired
    private OrderChildDao orderChildDao;

    @Override
    public void saveRecord(BreakContractDriverRecordAddParam param) {
        orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

        BreakContractDriverRecord record = new BreakContractDriverRecord();
        record.setTriggerType(BreakContractRecordEnum.TriggerType.MANUAL.getCode());
        record.setChildNo(param.getChildNo());
        record.setFigure(param.getFigure());

        if (param.getTimeLimit() != null) {
            record.setTimeLimit(param.getTimeLimit());
            record.setLimitTime(LocalDateTime.now().plusSeconds(param.getTimeLimit().multiply(BigDecimal.valueOf(3600L)).intValue()));
        }

        record.setRemark(param.getRemark());

        breakContractDriverRecordDao.saveEntity(record);

    }
}
