package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.param.pc.GoodsOrderMapParam;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsDao extends BaseDao<OrderGoodsMapper, OrderGoods, Integer> {
    boolean updateWeight(@Param("orderId")Integer orderId, @Param("weight") BigDecimal weight);

    String getMaxOrderGoodsId();

    Optional<OrderGoods> getByOrderGoodsNo(String orderGoodsNo);

    Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo);

    Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo);


    IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param);

    void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus);

    IPage<OrderGoodsAPPVO> openOrderPageGoodsList(OrderGoodsListPageParam orderGoodsListPageParam);

    IPage<OrderGoodsAPPVO> exclusiveOrderPageGoodsList(OrderGoodsListPageParam orderGoodsListPageParam, List<String> orderGoodsNoList);

    void updateOrderGoodsStatusByOrderGoodsNo(String orderGoodsNo, Integer code);

    void saveBatchEntity(List<OrderGoods> orderGoodsList);

    List<OrderGoods> getOrderGoodsListByOrderNo(String orderNo);

    List<OrderGoods> getOrderGoodsListByOrderNoAndLastArriveSendTime(String orderNo, LocalDateTime lastArriveSendTime);

    Optional<List<OrderGoods>> getOrderGoodsList();

    List<OrderGoods> getSendAddressSelect(GoodsOrderMapParam param);

    List<OrderGoods> listIntegralOrderGoodsSync();

}
