package com.clx.performance.controller.pc.breakcontract.carrier;

import com.clx.performance.param.pc.breakcontract.BreakContractRuleUpdateStatusParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract")
@Validated
@Api(tags = "承运端-违约方案")
@AllArgsConstructor
public class CarrierBreakContractRuleController {

    private final BreakContractOwnerRuleService breakContractOwnerRuleService;


    @ApiOperation(value = "取消运单", notes = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated BreakContractRuleUpdateStatusParam param) {
        breakContractOwnerRuleService.updateStatus(param);

        return Result.ok();
    }

}
