package com.clx.performance.controller.pc.breakcontract.carrier;

import com.clx.performance.param.pc.breakcontract.BreakContractDriverRecordAddParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract/driver")
@Validated
@Api(tags = "承运端-货主违约管理")
@AllArgsConstructor
public class CarrierBreakContractDriverRecordController {

    private final BreakContractDriverRecordService breakContractDriverRecordService;


    @ApiOperation(value = "新增违约记录", notes = "<br>By:艾庆国")
    @PostMapping("/saveRecord")
    @UnitCovert
    public Result<Void> saveRecord(@RequestBody @Validated BreakContractDriverRecordAddParam param) {
        breakContractDriverRecordService.saveRecord(param);

        return Result.ok();
    }

}
