package com.clx.performance.param.pc.breakcontract;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author: aiqingguo
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class BreakContractOwnerRecordAddParam {

    @ApiModelProperty("违约方类型：1平台 2货主")
    @NotNull(message = "违约方类型不能为空")
    private Integer breachContractPartyType;

    @ApiModelProperty("违约订单")
    @NotBlank(message = "违约订单不能为空")
    private String orderNo;

    @ApiModelProperty("违约金")
    @NotNull(message = "违约金不能为空")
    @MoneyInConvert
    private BigDecimal figure;

    @ApiModelProperty("备注")
    @NotBlank(message = "违约原因不能为空")
    private String remark;

}
