package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.mapper.settle.SettlementDriverDetailMapper;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 车主运单计费明细
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementDriverDetailDaoImpl extends BaseDaoImpl<SettlementDriverDetailMapper, SettlementDriverDetail, Integer> implements SettlementDriverDetailDao {
    @Override
    public boolean updateInvoiceType(SettlementDriverDetail item) {
        return update(lUdWrapper()
                .eq(SettlementDriverDetail::getId, item.getId())
                .set(SettlementDriverDetail::getInvoiceType, item.getInvoiceType())
        );
    }

    @Override
    public boolean updateSettlementNo(SettlementDriverDetail item) {
        return update(lUdWrapper()
                .eq(SettlementDriverDetail::getId, item.getId())
                .set(SettlementDriverDetail::getSettlementNo, item.getSettlementNo())
        );
    }

    @Override
    public Optional<SettlementDriverDetail> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementDriverDetail::getChildNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public IPage<SettlementDriverDetail> pageSettlementDriverDetail(PageCarrierSettlementDriverDetailParam param) {
        LambdaQueryWrapper<SettlementDriverDetail> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementDriverDetail :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementDriverDetail :: getOrderNo,param.getOrderNo());
        }
        if(Objects.nonNull(param.getDriverUserNo())){
            query.eq(SettlementDriverDetail :: getDriverUserNo,param.getDriverUserNo());
        }
        if(StringUtils.isNotBlank(param.getDriverUserName())){
            query.like(SettlementDriverDetail :: getDriverName,param.getDriverUserName());
        }
        query.orderByDesc(SettlementDriverDetail :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}
