package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwnerDetail")
@Validated
@Api(tags = "承运端-计费管理")
@AllArgsConstructor
public class CarrierSettlementOwnerDetailController {

    private final SettlementOwnerDetailService settlementOwnerDetailService;


    @ApiOperation(value = "运单计费列表（货主）",notes = "<br>By:刘海泉")
    @PostMapping("/pageSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerDetailVO>> pageSettlementOwnerDetail(@RequestBody @Validated PageCarrierSettlementOwnerDetailParam param) {
        IPage<CarrierPageSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageSettlementOwnerDetail(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "货主结算单运单明细",notes = "<br>By:姜文业")
    @PostMapping("/pageOwnerSettlementOrderDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageOwnerSettlementOwnerDetailVO>> pageOwnerSettlementOrderDetailList(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param) {
        IPage<PageOwnerSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageOwnerSettlementOrderDetailList(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "货主结算单下载",notes = "<br>By:姜文业")
    @PostMapping("/exportOwnerSettlementOrderDetailList")
    public void exportCarrierSettlementOwnerPageList(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = settlementOwnerDetailService.exportOwnerSettlementOrderDetail(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }



}
