package com.clx.performance;

import com.msl.common.config.ViewScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;

@SpringBootApplication
@EnableDiscoveryClient
@EnableAsync
//@ComponentScans({
//        @ComponentScan("com.clx.user.*"),
//        @ComponentScan("com.msl.common.utils.*"),
//})
@ComponentScan({"com.clx.performance.*", "com.msl.*"})
@EnableFeignClients(basePackages = {"com.msl.*", "com.clx.performance.*", "com.clx.order.*", "com.clx.user.*"})
@ViewScan(basePackage = "com.clx.user.view")
public class PerformanceApplication {

    public static void main(String[] args) {
        SpringApplication.run(PerformanceApplication.class, args);
    }

}
