package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.enums.DeleteStatusEnum;
import com.clx.performance.dao.PlatformAccountConfigDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.PlatformAccountConfig;
import com.clx.performance.param.pc.carrier.PagePlatformAccountConfigParam;
import com.clx.performance.param.pc.carrier.SavePlatformAccountConfigParam;
import com.clx.performance.service.PlatformAccountConfigService;
import com.clx.performance.struct.PlatformAccountConfigStruct;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.msl.common.exception.ServiceSystemException;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author jiangwenye
 * Date 2024-01-25
 * Time 09:43
 */
@Slf4j
@Service
@AllArgsConstructor
public class PlatformAccountConfigServiceImpl implements PlatformAccountConfigService {

    private final PlatformAccountConfigDao platformAccountConfigDao;

    private final PlatformAccountConfigStruct platformAccountConfigStruct;

    @Override
    public IPage<CarrierPagePlatformAccountConfigVO> pagePlatformAccountConfig(PagePlatformAccountConfigParam param) {
        IPage<PlatformAccountConfig> page =  platformAccountConfigDao.pagePlatformAccountConfig(param);
        List<CarrierPagePlatformAccountConfigVO> list = platformAccountConfigStruct.convertToVOList(page.getRecords());
        return new Page<CarrierPagePlatformAccountConfigVO>().setRecords(list).setTotal(page.getTotal()).setPages(page.getPages());
    }

    @Override
    public CarrierPagePlatformAccountConfigVO getPlatformAccountConfigDetail(Integer id) {
        //结算单详情
        PlatformAccountConfig platformAccountConfig =platformAccountConfigDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        CarrierPagePlatformAccountConfigVO detail = platformAccountConfigStruct.convertToDetail(platformAccountConfig);
        return detail;
    }

    @Override
    public void deletePlatformAccountConfig(Integer id) {
        platformAccountConfigDao.deletePlatformAccountConfig(id);
    }

    @Override
    public void updatePlatformAccountConfig(SavePlatformAccountConfigParam param) {

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        
        PlatformAccountConfig config = new PlatformAccountConfig();
        config.setId(param.getId());
        config.setBusinessType(param.getBusinessType());
        config.setOwnerType(param.getOwnerType());
        config.setInvoiceType(param.getInvoiceType());
        config.setInvoiceCompanyId(param.getInvoiceCompanyId());
        config.setInvoiceCompanyName(param.getInvoiceCompanyName());
        config.setConfigRange(param.getConfigRange());
        config.setCompanyName(param.getCompanyName());
        config.setBankName(param.getBankName());
        config.setOpenBank(param.getOpenBank());
        config.setBankCode(param.getBankCode());
        config.setBankCardNo(param.getBankCardNo());
        config.setModifiedUserNo(loginUserInfo.getUserNo());
        config.setModifiedUserName(loginUserInfo.getShadowUserName());
        if(!checkConfigOnly(config)){
            throw new ServiceSystemException(PerformanceResultEnum.PLATFORM_ACCOUNT_CONFIG_ONLY);
        }
        platformAccountConfigDao.updatePlatformAccountConfig(config);
    }

    @Override
    public void savePlatformAccountConfig(SavePlatformAccountConfigParam param){
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        PlatformAccountConfig config = new PlatformAccountConfig();
        config.setBusinessType(param.getBusinessType());
        config.setOwnerType(param.getOwnerType());
        config.setInvoiceType(param.getInvoiceType());
        config.setInvoiceCompanyId(param.getInvoiceCompanyId());
        config.setInvoiceCompanyName(param.getInvoiceCompanyName());
        config.setConfigRange(param.getConfigRange());
        config.setCompanyName(param.getCompanyName());
        config.setBankName(param.getBankName());
        config.setOpenBank(param.getOpenBank());
        config.setBankCode(param.getBankCode());
        config.setBankCardNo(param.getBankCardNo());
        config.setDeleteStatus(DeleteStatusEnum.YES.getCode());
        config.setCreateUserNo(loginUserInfo.getUserNo());
        config.setCreateUserName(loginUserInfo.getShadowUserName());
        if(!checkConfigOnly(config)){
            throw new ServiceSystemException(PerformanceResultEnum.PLATFORM_ACCOUNT_CONFIG_ONLY);
        }
        platformAccountConfigDao.saveEntity(config);
    }

    public boolean checkConfigOnly(PlatformAccountConfig config){
        List<PlatformAccountConfig> checkList = platformAccountConfigDao.checkPlatformAccountConfigOnly(config);
        if(CollectionUtils.isNotEmpty(checkList)){
            if(checkList.size() > 1){
                return false;
            }
            PlatformAccountConfig check = checkList.get(0);
            if(!Objects.equals(check.getId(),config.getId())){
                return false;
            }
        }
        return true;
    }

    @Override
    public List<CarrierPagePlatformAccountConfigVO> getPlatformAccountConfigByType(Integer businessType,
                                                                      Integer ownerType,
                                                                      Integer invoiceType,
                                                                      Integer invoiceCompanyId,
                                                                      Integer configRange){
        List<PlatformAccountConfig> configs = platformAccountConfigDao.getPlatformAccountConfigByType( businessType, ownerType, invoiceType, invoiceCompanyId, configRange);
        List<CarrierPagePlatformAccountConfigVO> list = platformAccountConfigStruct.convertToVOList(configs);
        return list;
    }

}
