package com.clx.performance.controller.pc.carrier;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.*;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwner")
@Validated
@Api(tags = "承运端-货主结算")
@AllArgsConstructor
public class CarrierSettlementOwnerController {

    private final SettlementOwnerService settlementOwnerService;


    @ApiOperation(value = "结算单详情",notes = "<br>By:李瑞新")
    @GetMapping("/getCarrierSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerDetailVO> getCarrierSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerDetail(id));
    }



    @ApiOperation(value = "承运端-结算单列表（货主）",notes = "<br>By:刘海泉")
    @PostMapping("/pageCarrierSettlementOwner")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerVO>> pageCarrierSettlementOwner(@RequestBody @Validated PageCarrierSettlementOwnerParam param) {
        IPage<CarrierPageSettlementOwnerVO> page = settlementOwnerService.pageCarrierSettlementOwner(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "货主结算单下载",notes = "<br>By:姜文业")
    @PostMapping("/exportCarrierSettlementOwnerPageList")
    public void exportCarrierSettlementOwnerPageList(@RequestBody @Validated PageCarrierSettlementOwnerParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = settlementOwnerService.exportCarrierSettlementOwnerPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @ApiOperation(value = "货主结算单快递页面开票信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerInvoiceCompany")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerCompanyVO> getCarrierSettlementOwnerInvoiceCompany(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerInvoiceCompany(id));
    }

    @ApiOperation(value = "货主结算单快递页面联系人信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerCompanyContact")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerCompanyContactVO> getCarrierSettlementOwnerCompanyContact(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerCompanyContact(id));
    }

    @ApiOperation(value = "货主结算单付款页面收款人信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerPayee")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerPayeeVO> getCarrierSettlementOwnerPayee(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerPayee(id));
    }

    @ApiOperation(value = "货主结算单快递页面快递信息",notes = "<br>By:姜文业")
    @GetMapping("/getCarrierSettlementOwnerExpress")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerExpressVO> getCarrierSettlementOwnerExpress(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerExpress(id));
    }

    @ApiOperation(value = "货主结算单上传结算凭证",notes = "<br>By:姜文业")
    @PostMapping("/uploadInvoiceImg")
    public Result uploadInvoiceImg(@RequestBody @Validated UploadInvoiceImgParam param) {
        settlementOwnerService.uploadInvoiceImg(param);
        return Result.ok();
    }

    @ApiOperation(value = "货主结算单填写快递信息",notes = "<br>By:姜文业")
    @PostMapping("/saveExpress")
    public Result saveExpress(@RequestBody @Validated SaveExpressParam param) {
        settlementOwnerService.saveExpress(param);
        return Result.ok();
    }

    @ApiOperation(value = "货主结算单付款提交",notes = "<br>By:姜文业")
    @PostMapping("/savePayee")
    public Result savePayee(@RequestBody @Validated SavePayeeParam param) {
        settlementOwnerService.savePayee(param);
        return Result.ok();
    }

    @ApiOperation(value = "编辑结算单状态",notes = "<br>By:姜文业")
    @PostMapping("/updateStatusByOrderNo")
    public Result updateStatusByOrderNo(@RequestBody @Validated UpdateStatusParam param) {
        settlementOwnerService.updateStatusByOrderNo(param.getOrderNo(), param.getSettlementPeriodType(), param.getFromStatus(), param.getToStatus());
        return Result.ok();
    }

    @ApiOperation(value = "货主结算单付款确认",notes = "<br>By:姜文业")
    @GetMapping("/payeeConfirm")
    @UnitCovert(param = false)
    public Result payeeConfirm(@NotNull(message = "结算单号不能为空") String settlementNo) {
        settlementOwnerService.payeeConfirm(settlementNo);
        return Result.ok();
    }

    @ApiOperation(value = "获取结算平台收款账号",notes = "<br>By:李瑞新")
    @GetMapping("/getSettlementPlatformAccount")
    public Result<SettlementPlatformAccountVO> getSettlementPlatformAccount(@NotNull(message = "结算单号不能为空") String settlementNo) {
        return Result.ok(settlementOwnerService.getCarrierSettlementPlatformAccount(settlementNo));
    }

    @ApiOperation(value = "合并结算单",notes = "<br>By:刘海泉")
    @PostMapping("/mergeOwnerSettlement")
    public Result<Object> mergeOwnerSettlement(@RequestBody @Validated MergeOwnerSettlementParam param) {
        settlementOwnerService.mergeOwnerSettlement(param);
        return Result.ok();
    }
}
