package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectLineReportQualitySaveParam {

    @ApiModelProperty(value = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;
    @ApiModelProperty(value = "图片列表")
    private List<String> imageList;

    @ApiModelProperty(value = "无法到达交货地原因", example = "车辆问题")
    @NotBlank(message = "无法到达交货地原因不能为空")
    private String remark;

}
