package com.clx.performance.service.impl.linewarn;

import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderInfoVO;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.linewarn.LineWarnOrderGoodsDao;
import com.clx.performance.dto.linewarn.LineWarnCommonInfoDTO;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.extranal.user.OrderService;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.linewarn.LineWarnOrderGoods;
import com.clx.performance.param.mq.linewarn.LineWarnLineWarnMqParam;
import com.clx.performance.param.mq.linewarn.LineWarnNoticeMqParam;
import com.clx.performance.param.mq.linewarn.LineWarnOrderGoodsAddMqParam;
import com.clx.performance.service.linewarn.*;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.gd.GdUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Slf4j
@Service
public class LineWarnMqHandlerServiceImpl implements LineWarnMqHandlerService {

    // 缺省装卸车时间
    private static final int DEFAULT_LOAD_UNLOAD_TIME = 60;
    private static final int DEFAULT_LOAD_UNLOAD_DAY = 7;

    @Autowired
    private OrderGoodsDao orderGoodsDao;
    @Autowired
    private LineWarnOrderGoodsDao lineWarnOrderGoodsDao;
    @Autowired
    private OrderFeign orderFeign;
    @Autowired
    private OrderService orderService;
    @Autowired
    private GdUtils gdUtils;
    @Autowired
    private LineWarnTakeWarnService lineWarnTakeWarnService;
    @Autowired
    private LineWarnUnloadWarnService lineWarnUnloadWarnService;
    @Autowired
    private LineWarnLoadWarnService lineWarnLoadWarnService;
    @Autowired
    private LineWarnCongestionWarnService lineWarnCongestionWarnService;
    @Autowired
    private LineWarnWeatherWarnService lineWarnWeatherWarnService;
    @Autowired
    private LineWarnOrderChildWarnService lineWarnOrderChildWarnService;
    @Autowired
    private LineWarnLineWarnService lineWarnLineWarnService;
    @Autowired
    private OrderChildDao orderChildDao;



    @Override
    public void orderGoodsAdd(LineWarnOrderGoodsAddMqParam mq) {
        OrderGoods orderGoods = orderGoodsDao
                .getByOrderGoodsNo(mq.getOrderGoodsNo()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        FeignOrderInfoVO orderInfo = orderService
                .getOrderInfo(orderGoods.getOrderNo()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        // 计算货源地到
        int arriveSendExpectTime = gdUtils.getNeedTime(new BigDecimal[]{orderGoods.getSendLongitude(),
                orderGoods.getSendLatitude()}, orderGoods.getReceiveLongitude(), orderGoods.getReceiveLatitude());

        LineWarnOrderGoods lineWarnOrderGoods = new LineWarnOrderGoods();
        lineWarnOrderGoods.setOrderGoodsNo(orderGoods.getOrderGoodsNo());
        lineWarnOrderGoods.setTransportEndTime(LocalDateTimeUtils.parseTime(orderInfo.getTransportEndTime()));
        lineWarnOrderGoods.setPendingOrderTime(orderGoods.getPendingOrderTime());
        lineWarnOrderGoods.setArriveReceiveExpectTime(arriveSendExpectTime==0? null : arriveSendExpectTime);
        lineWarnOrderGoodsDao.saveEntity(lineWarnOrderGoods);
    }

    @Override
    public void lineWarn(LineWarnLineWarnMqParam mq) {
        LineWarnOrderGoods lineWarnOrderGoods = lineWarnOrderGoodsDao
                .getByOrderGoodsNo(mq.getOrderGoodsNo()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        OrderGoods orderGoods = orderGoodsDao
                .getByOrderGoodsNo(mq.getOrderGoodsNo()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        LineWarnCommonInfoDTO lineWarnCommonInfo = new LineWarnCommonInfoDTO();
        lineWarnCommonInfo.setOrderGoodsNo(orderGoods.getOrderGoodsNo());
        lineWarnCommonInfo.setTransportEndTime(lineWarnOrderGoods.getTransportEndTime());
        lineWarnCommonInfo.setPendingOrderTime(lineWarnOrderGoods.getPendingOrderTime());
        lineWarnCommonInfo.setArriveReceiveExpectTime(lineWarnOrderGoods.getArriveReceiveExpectTime());

        lineWarnCommonInfo.setTaskCount(orderGoods.getNeedTruckNum());
        // 装卸车时间
        Integer loadTimeAvg = orderChildDao.loadTimeAvg(orderGoods.getSendAddressId(), orderGoods.getReceiveAddressId(),
                orderGoods.getSendSystemAddressId(), orderGoods.getReceiveSystemAddressId(),
                LocalDateTimeUtils.formatTime(LocalDateTime.now().minusDays(DEFAULT_LOAD_UNLOAD_DAY)));
        Integer unloadTimeAvg = orderChildDao.loadTimeAvg(orderGoods.getSendAddressId(), orderGoods.getReceiveAddressId(),
                orderGoods.getSendSystemAddressId(), orderGoods.getReceiveSystemAddressId(),
                LocalDateTimeUtils.formatTime(LocalDateTime.now().minusDays(DEFAULT_LOAD_UNLOAD_DAY)));
        lineWarnCommonInfo.setLoadTimeAvg(loadTimeAvg!=null? loadTimeAvg:DEFAULT_LOAD_UNLOAD_TIME);
        lineWarnCommonInfo.setUnloadTimeAvg(unloadTimeAvg!=null? unloadTimeAvg:DEFAULT_LOAD_UNLOAD_TIME);

        log.info("线路预警, lineWarnCommonInfo:{}", lineWarnCommonInfo);

        // 接单预警
        try {
            lineWarnTakeWarnService.takeWarn(orderGoods, lineWarnCommonInfo);
        }catch (Exception e){
            log.info("接单预警异常，msg:{}", e.getMessage());
        }

        // 装车预警
        try{
            lineWarnLoadWarnService.loadWarn(orderGoods, lineWarnCommonInfo);
        }catch (Exception e){
            log.info("装车预警异常，msg:{}", e.getMessage());
        }

        // 卸车预警
        try{
            lineWarnUnloadWarnService.unloadWarn(orderGoods, lineWarnCommonInfo);
        }catch (Exception e){
            log.info("卸车预警异常，msg:{}", e.getMessage());
        }

        // 天气预警
        try{
            lineWarnWeatherWarnService.weatherWarn(orderGoods, lineWarnCommonInfo);
        }catch (Exception e){
            log.info("天气预警异常，msg:{}", e.getMessage());
        }

        // 运单异常
        try{
            lineWarnOrderChildWarnService.orderChildWarn(orderGoods, lineWarnCommonInfo);
        }catch (Exception e){
            log.info("运单异常异常，msg:{}", e.getMessage());
        }

        // 拥堵预警
        try {
            lineWarnCongestionWarnService.congestionWarn(orderGoods, lineWarnCommonInfo);
        } catch (Exception e) {
            log.info("拥堵预警异常，msg:{}", e.getMessage());
        }

        // 线路异常
        try {
            lineWarnLineWarnService.lineAbnormalWarn(orderGoods, lineWarnCommonInfo);
        } catch (Exception e) {
            log.info("线路异常，msg:{}", e.getMessage());
        }

    }

    @Override
    public void notice(LineWarnNoticeMqParam mq) {

    }

}
