package com.clx.performance.service.impl.linewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.linewarn.LineWarnInfoDao;
import com.clx.performance.dao.linewarn.LineWarnLogDao;
import com.clx.performance.dao.linewarn.LineWarnOrderGoodsDao;
import com.clx.performance.dao.linewarn.LineWarnRangeDao;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.enums.linewarn.LineWarnInfoEnum;
import com.clx.performance.enums.linewarn.LineWarnLogEnum;
import com.clx.performance.enums.linewarn.LineWarnRangEnum;
import com.clx.performance.model.linewarn.LineWarnInfo;
import com.clx.performance.model.linewarn.LineWarnLog;
import com.clx.performance.model.linewarn.LineWarnRang;
import com.clx.performance.param.pc.linewarn.LineWarnInfoResolveUpdateParam;
import com.clx.performance.param.pc.linewarn.LineWarnInfoSuspendUpdateParam;
import com.clx.performance.param.pc.linewarn.PageLineWarnInfoParam;
import com.clx.performance.service.linewarn.LineWarnInfoService;
import com.clx.performance.service.trace.TruckTraceService;
import com.clx.performance.struct.linewarn.LineWarnInfoStruct;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.linewarn.LineWarnInfoVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class LineWarnInfoServiceImpl implements LineWarnInfoService {

    @Autowired
    private LineWarnInfoDao lineWarnInfoDao;
    @Autowired
    private LineWarnLogDao lineWarnLogDao;
    @Autowired
    private LineWarnRangeDao lineWarnRangeDao;
    @Autowired
    private LineWarnOrderGoodsDao lineWarnOrderGoodsDao;

    @Autowired
    private LineWarnInfoStruct lineWarnInfoStruct;

    @Autowired
    private TruckTraceService truckTraceService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateSuspend(LineWarnInfoSuspendUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        LocalDateTime endTime = LocalDateTimeUtils.parseTime(param.getWarnEndTime());

        LineWarnInfo lineWarnInfo = lineWarnInfoDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        lineWarnInfo.setSuspendTime(endTime);
        lineWarnInfoDao.updateSuspendTime(lineWarnInfo);

        LineWarnLog lineWarnLog = new LineWarnLog();
        lineWarnLog.setInfoId(lineWarnInfo.getId());
        lineWarnLog.setType(LineWarnLogEnum.Type.SUSPEND.getCode());
        lineWarnLog.setContent(LineWarnLogEnum.Type.SUSPEND.getMsg());
        lineWarnLog.setOrderGoodsNo(lineWarnInfo.getOrderGoodsNo());
        lineWarnLog.setWarnName(lineWarnInfo.getWarnName());
        lineWarnLog.setWarnEndTime(endTime);
        lineWarnLog.setWarnTime(lineWarnInfo.getWarnTime());
        lineWarnLog.setCreateBy(loginUserInfo.getUserName());
        lineWarnLogDao.saveEntity(lineWarnLog);

        LineWarnRang lineWarnRang = new LineWarnRang();
        lineWarnRang.setWarnConfigId(lineWarnInfo.getWarnConfigId());
        lineWarnRang.setWarnName(lineWarnInfo.getWarnName());
        lineWarnRang.setOrderGoodsNo(lineWarnInfo.getOrderGoodsNo());
        lineWarnRang.setWarnEndTime(endTime);
        lineWarnRang.setStatus(LineWarnRangEnum.Status.ENABLE.getCode());
        lineWarnRang.setCreateBy(loginUserInfo.getUserName());

        // 禁用旧数据
        lineWarnRangeDao.updateDisable(lineWarnRang);
        // 新增新数据
        lineWarnRangeDao.saveEntity(lineWarnRang);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateResolve(LineWarnInfoResolveUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        LineWarnInfo lineWarnInfo = lineWarnInfoDao.findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);
        lineWarnInfo.setStatus(LineWarnInfoEnum.Status.RESOLVE.getCode());
        lineWarnInfoDao.updateStatus(lineWarnInfo);

        LineWarnLog lineWarnLog = new LineWarnLog();
        lineWarnLog.setInfoId(lineWarnInfo.getId());
        lineWarnLog.setType(LineWarnLogEnum.Type.RESOLVE.getCode());
        lineWarnLog.setContent(LineWarnLogEnum.Type.RESOLVE.getMsg());
        lineWarnLog.setOrderGoodsNo(lineWarnInfo.getOrderGoodsNo());
        lineWarnLog.setWarnName(lineWarnInfo.getWarnName());
        lineWarnLog.setWarnTime(lineWarnInfo.getWarnTime());
        lineWarnLog.setCreateBy(loginUserInfo.getUserName());

        lineWarnLogDao.saveEntity(lineWarnLog);
    }
//
//    @Override
//    public VehicleTraceVO getTrace(Integer id) {
//        VehicleWarnInfo vehicleWarnInfo = vehicleWarnInfoDao.findById(id).orElseThrow(ResultEnum.DATA_NOT_FIND);
//        OrderChild orderChild = orderChildDao.getByChildNo(vehicleWarnInfo.getChildNo()).orElseThrow(ResultEnum.DATA_NOT_FIND);
//
//        LocalDateTime beginTime = vehicleWarnInfo.getTakeTime();
//        LocalDateTime endTime = LocalDateTime.now();
//        if (orderChild.getArriveSendTime() != null) {endTime = orderChild.getArriveSendTime();}
//        if (orderChild.getLoadTime() != null) {endTime = orderChild.getLoadTime();}
//        if (orderChild.getArriveReceiveTime() != null) {endTime = orderChild.getArriveReceiveTime();}
//        if (orderChild.getUnloadTime() != null) {endTime = orderChild.getUnloadTime();}
//        if (orderChild.getConfirmTime() != null) {endTime = orderChild.getConfirmTime();}
//        if (orderChild.getSettleTime() != null) {endTime = orderChild.getSettleTime();}
//        if (orderChild.getFinishTime() != null) {endTime = orderChild.getFinishTime();}
//        if (endTime.isAfter(beginTime.plusDays(TRUCK_TRACE_DAY_MAX))) {endTime = beginTime.plusDays(TRUCK_TRACE_DAY_MAX);}      //最多查询3天
//
//        List<DriverTruckTraceVO> truckTraceList = truckTraceService.listTruckTraceByTime(vehicleWarnInfo.getTruckNo(),
//                LocalDateTimeUtils.formatTime(beginTime), LocalDateTimeUtils.formatTime(endTime));
//        // 接单重车、卸车空车
//        for (DriverTruckTraceVO item : truckTraceList) {
//            item.setTruckStatus(DriverTruckEnum.TraceTruckStatus.HEAVY.getCode());
//            if (orderChild.getCancelTime() != null){
//                if (LocalDateTimeUtils.parseTime(item.getGpsTime()).isAfter(orderChild.getCancelTime())){
//                    item.setTruckStatus(DriverTruckEnum.TraceTruckStatus.EMPTY.getCode());}
//            }
//            if (orderChild.getUnloadTime() != null){
//                if (LocalDateTimeUtils.parseTime(item.getGpsTime()).isAfter(orderChild.getUnloadTime())){
//                    item.setTruckStatus(DriverTruckEnum.TraceTruckStatus.EMPTY.getCode());}
//            }
//        }
//        List<DriverTraceVO> driverTraceList = truckTraceService.listDriverTraceByTime(vehicleWarnInfo.getDriverUserNo(),
//                LocalDateTimeUtils.formatTime(beginTime), LocalDateTimeUtils.formatTime(endTime));
//
//        VehicleTraceVO result = new VehicleTraceVO();
//        result.setDriverTraceList(truckTraceService.splitDriverTrace(driverTraceList));
//        result.setTruckTraceList(truckTraceService.splitTruckTrace(truckTraceList));
//
//        return result;
//    }

    @Override
    public LineWarnInfoVO getInfo(Integer id) {
        return lineWarnInfoStruct.convert(lineWarnInfoDao.findById(id).orNull());

    }

    @Override
    public IPage<LineWarnInfoVO> pageInfo(PageLineWarnInfoParam param) {
        Page<LineWarnInfoVO> page = lineWarnInfoStruct.convertPage(lineWarnInfoDao.pageByParam(param));

        List<String> orderGoodsNoList = page.getRecords().stream().map(item -> item.getOrderGoodsNo()).collect(Collectors.toList());
        if (!orderGoodsNoList.isEmpty()) {

        }
        return page;

    }
}
