package com.clx.performance.controller.pc.linewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.linewarn.*;
import com.clx.performance.service.linewarn.LineWarnInfoService;
import com.clx.performance.vo.pc.linewarn.LineWarnInfoVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;


@Slf4j
@RestController
@Validated
@Api(tags = "线路预警-预警信息")
@RequestMapping(value="/pc/lineWarnInfo")
public class LineWarnInfoController {

    @Autowired
    private LineWarnInfoService lineWarnInfoService;

    @ApiOperation(value = "更新预警暂停", notes = "<br>By:艾庆国")
    @PostMapping("/updateSuspend")
    public Result<Void> updateSuspend(@RequestBody @Validated LineWarnInfoSuspendUpdateParam param) {
        lineWarnInfoService.updateSuspend(param);
        return Result.ok();
    }

    @ApiOperation(value = "更新处理", notes = "<br>By:艾庆国")
    @PostMapping("/updateResolve")
    public Result<Void> updateConfig(@RequestBody @Validated LineWarnInfoResolveUpdateParam param) {
        lineWarnInfoService.updateResolve(param);
        return Result.ok();
    }

//    @ApiOperation(value = "获取轨迹",notes = "<br>By:艾庆国")
//    @GetMapping("/getTrace")
//    public Result<VehicleTraceVO> getTrace(@NotNull(message = "id不能为空") @Validated Integer id) {
//        return Result.ok(lineWarnInfoService.getTrace(id));
//    }

    @ApiOperation(value = "获取预警信息",notes = "<br>By:艾庆国")
    @GetMapping("/getInfo")
    public Result<LineWarnInfoVO> getInfo(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(lineWarnInfoService.getInfo(id));
    }

    @ApiOperation(value = "分页搜索预警信息列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageInfo")
    public Result<PageData<LineWarnInfoVO>> pageInfo(@RequestBody @Validated PageLineWarnInfoParam param) {
        IPage<LineWarnInfoVO> page = lineWarnInfoService.pageInfo(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
