package com.clx.performance.service.impl.collect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.collect.CollectTruckRefuelDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.collect.CollectTruckRefuel;
import com.clx.performance.param.app.collect.CollectTruckRefuelSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.service.collect.CollectTruckRefuelService;
import com.clx.performance.struct.collect.CollectTruckRefuelStruct;
import com.clx.performance.vo.app.collect.CollectTruckRefuelVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class CollectTruckRefuelServiceImpl implements CollectTruckRefuelService {

    @Autowired
    private CollectTruckRefuelDao collectTruckRefuelDao;

    @Autowired
    private OrderChildDao orderChildDao;

    @Autowired
    private CollectTruckRefuelStruct collectTruckRefuelStruct;


    @Override
    public void saveRefuelReport(CollectTruckRefuelSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

        CollectTruckRefuel collectTruckRefuel = new CollectTruckRefuel();
        collectTruckRefuel.setUserNo(userNo);
        collectTruckRefuel.setName(loginUserInfo.getUserName());
        collectTruckRefuel.setMobile(loginUserInfo.getUserMobile());

        collectTruckRefuel.setTruckNo(orderChild.getTruckNo());
        collectTruckRefuel.setChildNo(param.getChildNo());
        collectTruckRefuel.setSendAddressId(orderChild.getSendAddressId());
        collectTruckRefuel.setSendAddress(orderChild.getSendAddress());
        collectTruckRefuel.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectTruckRefuel.setReceiveAddress(orderChild.getReceiveAddress());

        collectTruckRefuel.setLoadImage(param.getLoadImageList()==null? null:JSON.toJSONString(param.getLoadImageList()));
        collectTruckRefuel.setUnloadImage(param.getUnloadImageList()==null? null:JSON.toJSONString(param.getUnloadImageList()));
        collectTruckRefuel.setLoadOil(param.getLoadOil());
        collectTruckRefuel.setUnloadOil(param.getUnloadOil());
        collectTruckRefuel.setReportTime(LocalDateTime.now());
        collectTruckRefuel.setCreateTime(collectTruckRefuel.getReportTime());

        collectTruckRefuelDao.saveEntity(collectTruckRefuel);
    }

    @Override
    public CollectTruckRefuelVO getReportInfo(Integer id) {

        return collectTruckRefuelDao.getEntityByKey(id).map(collectTruckRefuelStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
    }

    @Override
    public IPage<CollectTruckRefuelVO> pageRefuelReport(PageCollectTruckRefuelParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTruckRefuelDao.pageRefuel(param);
    }

    @Override
    public IPage<CollectTruckRefuelVO> carrierPageRefuelReport(CarrierPageCollectTruckRefuelParam param) {
        return collectTruckRefuelDao.carrierPageRefuel(param);
    }
}
