package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆位置上报
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CollectTruckLocation implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private String name;                            //用户姓名
    private String mobile;                          //手机号码
    private String truckNo;                         //车牌号
    private String province;                        //省
    private String city;                            //市
    private String county;                          //区县
    private String town;                            //乡镇
    private String street;                          //街道
    private String address;                         //详细地址
    private String fullAddress;                     //全地址
    private BigDecimal longitude;                   //经度
    private BigDecimal latitude;                    //纬度
    private Integer truckOrderStatus;               //车辆出车状态 1:空车 2:运单-空车 3:运单-重车
    private LocalDateTime reportTime;               //上报时间
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}