package com.clx.performance.mapper.collect;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.collect.CollectTruckRefuel;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.sqlProvider.collect.CollectTruckRefuelSqlProvider;
import com.clx.performance.vo.app.collect.CollectTruckRefuelVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 油表上报信息
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface CollectTruckRefuelMapper extends BaseMapper<CollectTruckRefuel> {
    /**
     * @see CollectTruckRefuelSqlProvider#pageRefuel(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.collect.PageCollectTruckRefuelParam)
     */
    @SelectProvider(type = CollectTruckRefuelSqlProvider.class, method = "pageRefuel")
    IPage<CollectTruckRefuelVO> pageRefuel(@Param("page") Page<CollectTruckRefuelVO> page, @Param("param") PageCollectTruckRefuelParam param);
    /**
     * @see CollectTruckRefuelSqlProvider#carrierPageRefuel(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam)
     */
    @SelectProvider(type = CollectTruckRefuelSqlProvider.class, method = "carrierPageRefuel")
    IPage<CollectTruckRefuelVO> carrierPageRefuel(@Param("page") Page<CollectTruckRefuelVO> page, @Param("param") CarrierPageCollectTruckRefuelParam param);

}