package com.clx.performance.mapper.collect;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.collect.CollectTruckLeave;
import com.clx.performance.param.app.collect.PageCollectTruckLeaveParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLeaveParam;
import com.clx.performance.sqlProvider.collect.CollectTruckLeaveSqlProvider;
import com.clx.performance.vo.app.collect.CollectTruckLeaveVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 司机请假表
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface CollectTruckLeaveMapper extends BaseMapper<CollectTruckLeave> {
    /**
     * @see CollectTruckLeaveSqlProvider#pageLeave(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.collect.PageCollectTruckLeaveParam)
     */
    @SelectProvider(type = CollectTruckLeaveSqlProvider.class, method = "pageLeave")
    IPage<CollectTruckLeaveVO> pageLeave(@Param("page") Page<CollectTruckLeaveVO> page, @Param("param") PageCollectTruckLeaveParam param);
    /**
     * @see CollectTruckLeaveSqlProvider#carrierPageLeave(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLeaveParam)
     */
    @SelectProvider(type = CollectTruckLeaveSqlProvider.class, method = "carrierPageLeave")
    IPage<CollectTruckLeaveVO> carrierPageLeave(@Param("page") Page<CollectTruckLeaveVO> page, @Param("param") CarrierPageCollectTruckLeaveParam param);

}