package com.clx.performance.mapper.collect;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.collect.CollectLineReport;
import com.clx.performance.param.app.collect.PageCollectLineReportParam;
import com.clx.performance.param.pc.carrier.*;
import com.clx.performance.sqlProvider.collect.CollectLineReportSqlProvider;
import com.clx.performance.vo.app.collect.CollectLineReportVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 线路信息上报
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface CollectLineReportMapper extends BaseMapper<CollectLineReport> {
    /**
     * @see CollectLineReportSqlProvider#pageLineReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.collect.PageCollectLineReportParam)
     */
    @SelectProvider(type = CollectLineReportSqlProvider.class, method = "pageLineReport")
    IPage<CollectLineReportVO> pageLineReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") PageCollectLineReportParam param);

    /**
     * @see CollectLineReportSqlProvider#carrierPageSendAddressReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectSendAddressReportParam)
     */
    @SelectProvider(type = CollectLineReportSqlProvider.class, method = "carrierPageSendAddressReport")
    IPage<CollectLineReportVO> carrierPageSendAddressReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectSendAddressReportParam param);

    /**
     * @see CollectLineReportSqlProvider#carrierPageAbnormalReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectAbnormalReportParam)
     */
    @SelectProvider(type = CollectLineReportSqlProvider.class, method = "carrierPageAbnormalReport")
    IPage<CollectLineReportVO> carrierPageAbnormalReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectAbnormalReportParam param);

    /**
     * @see CollectLineReportSqlProvider#carrierPageNoTakeOrderReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectNoTakeOrderReportParam)
     */
    @SelectProvider(type = CollectLineReportSqlProvider.class, method = "carrierPageNoTakeOrderReport")
    IPage<CollectLineReportVO> carrierPageNoTakeOrderReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectNoTakeOrderReportParam param);

    /**
     * @see CollectLineReportSqlProvider#carrierPageQualityReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectQualityReportParam)
     */
    @SelectProvider(type = CollectLineReportSqlProvider.class, method = "carrierPageQualityReport")
    IPage<CollectLineReportVO> carrierPageQualityReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectQualityReportParam param);

    /**
     * @see CollectLineReportSqlProvider#carrierPageOtherReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectOtherReportParam)
     */
    @SelectProvider(type = CollectLineReportSqlProvider.class, method = "carrierPageOtherReport")
    IPage<CollectLineReportVO> carrierPageOtherReport(@Param("page") Page<CollectLineReportVO> page, @Param("param") CarrierPageCollectOtherReportParam param);

}