package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectTruckLocationDao;
import com.clx.performance.mapper.collect.CollectTruckLocationMapper;
import com.clx.performance.model.collect.CollectTruckLocation;
import com.clx.performance.param.app.collect.PageCollectTruckLocationParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLocationParam;
import com.clx.performance.vo.app.collect.CollectTrafficCongestionVO;
import com.clx.performance.vo.app.collect.CollectTruckLocationVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 车辆位置上报
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectTruckLocationDaoImpl extends BaseDaoImpl<CollectTruckLocationMapper, CollectTruckLocation, Integer> implements CollectTruckLocationDao {

    @Override
    public IPage<CollectTruckLocationVO> pageLocation(PageCollectTruckLocationParam param) {
        Page<CollectTruckLocationVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageLocation(page,param);
    }

    @Override
    public IPage<CollectTruckLocationVO> carrierPageLocation(CarrierPageCollectTruckLocationParam param) {
        Page<CollectTruckLocationVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageLocation(page,param);
    }
}
