package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectTrafficCongestionDao;
import com.clx.performance.mapper.collect.CollectTrafficCongestionMapper;
import com.clx.performance.model.collect.CollectLineReport;
import com.clx.performance.model.collect.CollectTrafficCongestion;
import com.clx.performance.param.app.collect.PageCollectTraficCongestionParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTraficCongestionParam;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.app.collect.CollectTrafficCongestionVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 道路拥堵情况
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectTrafficCongestionDaoImpl extends BaseDaoImpl<CollectTrafficCongestionMapper, CollectTrafficCongestion, Integer> implements CollectTrafficCongestionDao {

    @Override
    public boolean updateAuditStatus(CollectTrafficCongestion item) {
        return update(lUdWrapper()
                .eq(CollectTrafficCongestion::getId, item.getId())
                .set(CollectTrafficCongestion::getAuditStatus, item.getAuditStatus())
        );
    }

    @Override
    public IPage<CollectTrafficCongestionVO> pageTraffic(PageCollectTraficCongestionParam param) {
        Page<CollectTrafficCongestionVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageTraffic(page,param);
    }

    @Override
    public IPage<CollectTrafficCongestionVO> carrierPageTraffic(CarrierPageCollectTraficCongestionParam param) {
        Page<CollectTrafficCongestionVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageTraffic(page,param);
    }
}
