package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTruckRefuelSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.service.collect.CollectTruckRefuelService;
import com.clx.performance.vo.app.collect.CollectTruckRefuelVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/refuel")
@Validated
@Api(tags = "承运PC-油表上报")
@AllArgsConstructor
public class CarrierDriverCollectTruckRefuelController {

    private final CollectTruckRefuelService collectTruckRefuelService;

    @ApiOperation(value = "分页查询油表上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRefuelReport")
    public Result<PageData<CollectTruckRefuelVO>> pageRefuelReport(@RequestBody @Validated CarrierPageCollectTruckRefuelParam param) {
        IPage<CollectTruckRefuelVO> page = collectTruckRefuelService.carrierPageRefuelReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
