package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTruckLocationSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckLocationParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLocationParam;
import com.clx.performance.service.collect.CollectTruckLocationService;
import com.clx.performance.vo.app.collect.CollectTruckLocationVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/location")
@Validated
@Api(tags = "承运PC-位置上报")
@AllArgsConstructor
public class CarrierDriverCollectTruckLocationController {

    private final CollectTruckLocationService collectTruckLocationService;

    @ApiOperation(value = "分页查询司机位置上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageLocationReport")
    public Result<PageData<CollectTruckLocationVO>> pageLocationReport(@RequestBody @Validated CarrierPageCollectTruckLocationParam param) {
        IPage<CollectTruckLocationVO> page = collectTruckLocationService.carrierPageLocationReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
