package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.clx.performance.service.settle.SettlementDriverService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementDriver")
@Validated
@Api(tags = "承运端-结算管理-车主结算单")
@AllArgsConstructor
public class CarrierSettlementDriverController {

    private final SettlementDriverService settlementDriverService;


    @ApiOperation(value = "结算单列表（车主）",notes = "<br>By:刘海泉")
    @PostMapping("/pageCarrierSettlementDriver")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementDriverVO>> pageCarrierSettlementDriver(@RequestBody @Validated PageCarrierSettlementDriverParam param) {
        IPage<CarrierPageSettlementDriverVO> page  = settlementDriverService.pageCarrierSettlementDriver(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }



}
