package com.clx.performance.vo.app.collect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆位置上报
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@ApiModel(description = "车辆位置上报")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckLocationVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "用户姓名", example = "")
    private String name;
    @ApiModelProperty(value = "手机号码", example = "")
    private String mobile;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
//    @ApiModelProperty(value = "省", example = "")
//    private String province;
//    @ApiModelProperty(value = "市", example = "")
//    private String city;
//    @ApiModelProperty(value = "区县", example = "")
//    private String county;
//    @ApiModelProperty(value = "乡镇", example = "")
//    private String town;
//    @ApiModelProperty(value = "街道", example = "")
//    private String street;
//    @ApiModelProperty(value = "详细地址", example = "")
//    private String address;
    @ApiModelProperty(value = "全地址", example = "")
    private String fullAddress;

    @ApiModelProperty(value = "经度", example = "")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度", example = "")
    private BigDecimal latitude;
    @ApiModelProperty(value = "车辆出车状态 1:空车 2重车", example = "")
    private Integer truckOrderStatus;
    @ApiModelProperty(value = "上报时间", example = "")
    private String reportTime;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}