package com.clx.performance.vo.app.collect;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 道路拥堵情况
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@ApiModel(description = "道路拥堵情况")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTrafficCongestionVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "用户姓名", example = "")
    private String name;
    @ApiModelProperty(value = "手机号码", example = "")
    private String mobile;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @ApiModelProperty(value = "省", example = "")
    private String province;
    @ApiModelProperty(value = "市", example = "")
    private String city;
    @ApiModelProperty(value = "区县", example = "")
    private String county;
    @ApiModelProperty(value = "乡镇", example = "")
    private String town;
    @ApiModelProperty(value = "街道", example = "")
    private String street;
    @ApiModelProperty(value = "详细地址", example = "")
    private String address;
    @ApiModelProperty(value = "经度", example = "")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度", example = "")
    private BigDecimal latitude;
    @ApiModelProperty(value = "预计拥堵时长", example = "")
    private BigDecimal jamTime;
    @ApiModelProperty(value = "现场照片", example = "", hidden = true)
    private String jamImage;
    @ApiModelProperty(value = "现场照片", example = "")
    private List<String> jamImageList;
    public List<String> getJamImageList() {
        return StringUtils.isEmpty(jamImage)? new ArrayList<>() : JSON.parseArray(jamImage, String.class);
    }

    @ApiModelProperty(value = "上报时间", example = "")
    private String reportTime;
    @ApiModelProperty(value = "审核状态：0待审核 1已审核", example = "")
    private Integer auditStatus;

    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}