package com.clx.performance.vo.pc.trace;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class DriverTruckTraceVO {

    @Schema(description = "正北方向夹角", example = "12.34")
    private BigDecimal angle;
    @Schema(description = "GPS 速度", example = "12.34")
    private BigDecimal speed;
    @Schema(description = "里程", example = "12.34")
    private BigDecimal mileage;
    @Schema(description = "海拔", example = "12.34")
    private BigDecimal height;
    @Schema(description = "经度", example = "123.45")
    private BigDecimal longitude;
    @Schema(description = "纬度", example = "12.34")
    private BigDecimal latitude;
    @Schema(description = "GPS 时间")
    private String gpsTime;
    @Schema(description = "停留开始时间")
    private String stayBeginTime;
    @Schema(description = "停留结束时间")
    private String stayEndTime;
    @Schema(description = "停留时长（min）", example = "12.3")
    private BigDecimal stayTime=BigDecimal.ZERO;
    @Schema(description = "车辆状态：1空车 2重车", example = "1")
    private Integer truckStatus;
    @Schema(description = "时间")
    private String createTime;
}
