package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class TransportVO {

    @Schema(description = "源运单编号", example = "1234", required = true)
    private String sourceChildNo;
    @Schema(description = "运单编号", example = "1234", required = true)
    private String childNo;

    @Schema(description = "风控状态 0-正常，1-单项异常，2-多项异常", example = "1")
    private Integer riskStatus;
    @Schema(description = "风控异常原因", example = "1")
    private String riskReason;

    @Schema(description = "同步状态 0-未同步，1-已同步，2-同步失败", example = "1")
    private Integer syncStatus;
    @Schema(description = "同步失败原因", example = "1")
    private String syncMsg;

    @Schema(description = "结算状态 0 未结算 1 已结算 2结算中 3结算失败 ", example = "1234124")
    private Integer settleStatus;
    @Schema(description = "结算方", example = "1")
    private Integer settleOrg;
    @Schema(description = "结算失败原因", example = "1")
    private String settleMsg;

    @Schema(description = "开票状态 0 未开票 1 已开票 ", example = "1234124")
    private Integer invoiceStatus;

    @Schema(description = "第三方运单状态 20-已卸货，30-已创建支付单", example = "1234124")
    private Integer thirdPartyChildStatus;

}
