package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

/**
 * @description:
 * @Author:liumingchao
 * @Date:2022/11/4 13:50
 */
@Getter
@Setter
@NoArgsConstructor
public class OrderChildTruckTraceDTO {

    @Schema(description = "运单号", required = true)
    private String childNo;
    @Schema(description = "定位时间", required = true)
    @NotBlank(message = "定位时间不能为空")
    private String locationTime;
    @Schema(description = "定位经度", required = true)
    @NotBlank(message = "定位经度不能为空")
    private String locationLon;
    @Schema(description = "定位纬度", required = true)
    @NotBlank(message = "定位纬度不能为空")
    private String locationLat;
    @Schema(description = "定位详细位置信息")
    private String locationAddress;

}
