package com.clx.performance.service.impl.collect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.collect.CollectTruckWaitDao;
import com.clx.performance.enums.InternalMessageTemplateEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.collect.CollectTruckWaitEnum;
import com.clx.performance.enums.integral.IntegralRecordEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.collect.CollectTruckWait;
import com.clx.performance.param.app.collect.CollectLineReportTruckWaitAuditParam;
import com.clx.performance.param.app.collect.CollectWaitReportReceiveAddressSaveParam;
import com.clx.performance.param.app.collect.CollectWaitReportSendAddressSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckWaitParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam;
import com.clx.performance.service.IntegralRecordService;
import com.clx.performance.service.SendInternalMessageService;
import com.clx.performance.service.collect.CollectWaitReportService;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.struct.collect.CollectTruckWaitStruct;
import com.clx.performance.vo.pc.collect.CollectTruckWaitVO;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class CollectWaitReportServiceImpl implements CollectWaitReportService {

    @Autowired
    private CollectTruckWaitDao collectTruckWaitDao;
    @Autowired
    private OrderChildDao orderChildDao;

    @Autowired
    private CollectTruckWaitStruct collectTruckWaitStruct;
    @Autowired
    private IntegralRuleService integralRuleService;
    @Autowired
    private IntegralRecordService integralRecordService;

    @Autowired
    SendInternalMessageService sendInternalMessageService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveSendAddressReport(CollectWaitReportSendAddressSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectTruckWait collectTruckWait = new CollectTruckWait();
        collectTruckWait.setUserNo(userNo);
        collectTruckWait.setName(loginUserInfo.getUserName());
        collectTruckWait.setMobile(loginUserInfo.getUserMobile());
        collectTruckWait.setTruckNo(orderChild.getTruckNo());

        collectTruckWait.setChildNo(param.getChildNo());
        collectTruckWait.setAddressId(orderChild.getSendAddressId());
        collectTruckWait.setAddress(orderChild.getSendAddress());

        collectTruckWait.setReportType(CollectTruckWait.ReportType.LOAD.getCode());
        collectTruckWait.setWaitType(param.getWaitType());

        collectTruckWait.setStationInTime(param.getStationTime());
        collectTruckWait.setStationInImage(param.getStationImageList()==null? null : JSON.toJSONString(param.getStationImageList()));

        collectTruckWait.setReportTime(LocalDateTime.now());
        collectTruckWait.setCreateTime(collectTruckWait.getReportTime());
        collectTruckWaitDao.saveEntity(collectTruckWait);

        //待审核：排队信息上报 站内信
        sendInternalMessageService.sendInternalMessageMq(InternalMessageTemplateEnum.PlatformType.CARRIER.getCode(),
                InternalMessageTemplateEnum.BusinessType.DRIVER_REPORT.getCode(),
                InternalMessageTemplateEnum.CUSTOM_DRIVER_REPORT_LINE_UP_INFO_CODE, List.of(loginUserInfo.getUserName()),null,null);


    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveReceiveAddressReport(CollectWaitReportReceiveAddressSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        CollectTruckWait collectTruckWait = new CollectTruckWait();
        collectTruckWait.setUserNo(userNo);
        collectTruckWait.setName(loginUserInfo.getUserName());
        collectTruckWait.setMobile(loginUserInfo.getUserMobile());
        collectTruckWait.setTruckNo(orderChild.getTruckNo());

        collectTruckWait.setChildNo(param.getChildNo());
        collectTruckWait.setAddressId(orderChild.getSendAddressId());
        collectTruckWait.setAddress(orderChild.getSendAddress());

        collectTruckWait.setReportType(CollectTruckWait.ReportType.UNLOAD.getCode());
        collectTruckWait.setWaitType(param.getWaitType());

        collectTruckWait.setStationInTime(param.getStationTime());
        collectTruckWait.setStationInImage(param.getStationImageList()==null? null:JSON.toJSONString(param.getStationImageList()));

        collectTruckWait.setReportTime(LocalDateTime.now());
        collectTruckWait.setCreateTime(collectTruckWait.getReportTime());
        collectTruckWaitDao.saveEntity(collectTruckWait);

        //待审核：排队信息上报 站内信
        sendInternalMessageService.sendInternalMessageMq(InternalMessageTemplateEnum.PlatformType.CARRIER.getCode(),
                InternalMessageTemplateEnum.BusinessType.DRIVER_REPORT.getCode(),
                InternalMessageTemplateEnum.CUSTOM_DRIVER_REPORT_LINE_UP_INFO_CODE, List.of(loginUserInfo.getUserName()),null,null);

    }

    @Override
    public CollectTruckWaitVO getReportInfo(Integer id) {
        return collectTruckWaitDao.getEntityByKey(id).map(collectTruckWaitStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

    }

    @Override
    public IPage<CollectTruckWaitVO> pageWaitReport(PageCollectTruckWaitParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTruckWaitDao.pageWaitReport(param);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateWaitReportAudit(CollectLineReportTruckWaitAuditParam param) {
        CollectTruckWait collectTruckWait = collectTruckWaitDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        collectTruckWait.setAuditStatus(CollectTruckWait.AuditStatus.AUDIT.getCode());
        collectTruckWaitDao.updateAuditStatus(collectTruckWait);

        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();

        // 保存积分
        if (Objects.equals(collectTruckWait.getReportType(), CollectTruckWait.ReportType.LOAD.getCode())) {
/*            if (Objects.equals(collectTruckWait.getWaitType(), CollectTruckWaitEnum.waitType.INNER.getCode())
                    || Objects.equals(collectTruckWait.getWaitType(), CollectTruckWaitEnum.waitType.OUTER.getCode())) {
                integralRecordService.addDriverReportRecord(ruleInfo, collectTruckWait.getTruckNo(), IntegralRecordEnum.Type.REPORT_SEND_ADDRESS_WAIT.getValue(),
                        ruleInfo.getDriverReportRule().getIntegralSendAddressWait(), IntegralRecordEnum.Type.REPORT_SEND_ADDRESS_WAIT.getMsg());
            } else {
                integralRecordService.addDriverReportRecord(ruleInfo, collectTruckWait.getTruckNo(), IntegralRecordEnum.Type.REPORT_SEND_ADDRESS_NO_WAIT.getValue(),
                        ruleInfo.getDriverReportRule().getIntegralSendAddressNoWait(), IntegralRecordEnum.Type.REPORT_SEND_ADDRESS_NO_WAIT.getMsg());
            }*/

            integralRecordService.addDriverReportRecord(ruleInfo, collectTruckWait.getTruckNo(), IntegralRecordEnum.Type.REPORT_SEND_ADDRESS_WAIT.getValue(),
                    ruleInfo.getDriverReportRule().getIntegralSendAddressWait(), IntegralRecordEnum.Type.REPORT_SEND_ADDRESS_WAIT.getMsg());

        }else {
/*            if (Objects.equals(collectTruckWait.getWaitType(), CollectTruckWaitEnum.waitType.INNER.getCode())
                    || Objects.equals(collectTruckWait.getWaitType(), CollectTruckWaitEnum.waitType.OUTER.getCode())) {
                integralRecordService.addDriverReportRecord(ruleInfo, collectTruckWait.getTruckNo(), IntegralRecordEnum.Type.REPORT_RECEIVE_ADDRESS_WAIT.getValue(),
                        ruleInfo.getDriverReportRule().getIntegralReceiveAddressWait(), IntegralRecordEnum.Type.REPORT_RECEIVE_ADDRESS_WAIT.getMsg());
            } else {
                integralRecordService.addDriverReportRecord(ruleInfo, collectTruckWait.getTruckNo(), IntegralRecordEnum.Type.REPORT_RECEIVE_ADDRESS_NO_WAIT.getValue(),
                        ruleInfo.getDriverReportRule().getIntegralReceiveAddressNoWait(), IntegralRecordEnum.Type.REPORT_RECEIVE_ADDRESS_NO_WAIT.getMsg());
            }*/
            integralRecordService.addDriverReportRecord(ruleInfo, collectTruckWait.getTruckNo(), IntegralRecordEnum.Type.REPORT_RECEIVE_ADDRESS_WAIT.getValue(),
                    ruleInfo.getDriverReportRule().getIntegralReceiveAddressWait(), IntegralRecordEnum.Type.REPORT_RECEIVE_ADDRESS_WAIT.getMsg());
        }
    }

    @Override
    public IPage<CollectTruckWaitVO> carrierPageWaitReport(CarrierPageCollectTruckWaitParam param) {
        return collectTruckWaitDao.carrierPageWaitReport(param);

    }
}
