package com.clx.performance.service.impl.collect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.collect.CollectTruckRefuelDao;
import com.clx.performance.enums.InternalMessageTemplateEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.integral.IntegralRecordEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.collect.CollectTruckRefuel;
import com.clx.performance.param.app.collect.CollectTruckRefuelSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.service.IntegralRecordService;
import com.clx.performance.service.SendInternalMessageService;
import com.clx.performance.service.collect.CollectTruckRefuelService;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.struct.collect.CollectTruckRefuelStruct;
import com.clx.performance.vo.pc.collect.CollectTruckRefuelVO;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class CollectTruckRefuelServiceImpl implements CollectTruckRefuelService {

    @Autowired
    private CollectTruckRefuelDao collectTruckRefuelDao;

    @Autowired
    private OrderChildDao orderChildDao;

    @Autowired
    private CollectTruckRefuelStruct collectTruckRefuelStruct;

    @Autowired
    private IntegralRuleService integralRuleService;
    @Autowired
    private IntegralRecordService integralRecordService;
    @Autowired
    SendInternalMessageService sendInternalMessageService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveRefuelReport(CollectTruckRefuelSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);

        CollectTruckRefuel collectTruckRefuel = new CollectTruckRefuel();
        collectTruckRefuel.setUserNo(userNo);
        collectTruckRefuel.setName(loginUserInfo.getUserName());
        collectTruckRefuel.setMobile(loginUserInfo.getUserMobile());

        collectTruckRefuel.setTruckNo(orderChild.getTruckNo());
        collectTruckRefuel.setChildNo(param.getChildNo());
        collectTruckRefuel.setSendAddressId(orderChild.getSendAddressId());
        collectTruckRefuel.setSendAddress(orderChild.getSendAddress());
        collectTruckRefuel.setReceiveAddressId(orderChild.getReceiveAddressId());
        collectTruckRefuel.setReceiveAddress(orderChild.getReceiveAddress());

        collectTruckRefuel.setLoadImage(param.getLoadImageList()==null? null:JSON.toJSONString(param.getLoadImageList()));
        collectTruckRefuel.setUnloadImage(param.getUnloadImageList()==null? null:JSON.toJSONString(param.getUnloadImageList()));
        collectTruckRefuel.setLoadOil(param.getLoadOil());
        collectTruckRefuel.setUnloadOil(param.getUnloadOil());
        collectTruckRefuel.setReportTime(LocalDateTime.now());
        collectTruckRefuel.setCreateTime(collectTruckRefuel.getReportTime());

        collectTruckRefuelDao.saveEntity(collectTruckRefuel);

        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();

        // 报存积分
        integralRecordService.addDriverReportRecord(ruleInfo, collectTruckRefuel.getTruckNo(), IntegralRecordEnum.Type.REPORT_REFUEL.getValue(),
                ruleInfo.getDriverReportRule().getIntegralRefuel(), IntegralRecordEnum.Type.REPORT_REFUEL.getMsg());

        //司机上报：油表信息 站内信
        sendInternalMessageService.sendInternalMessageMq(InternalMessageTemplateEnum.PlatformType.CARRIER.getCode(),
                InternalMessageTemplateEnum.BusinessType.DRIVER_REPORT.getCode(),
                InternalMessageTemplateEnum.CUSTOM_DRIVER_REPORT_REFUEL_CODE, List.of(loginUserInfo.getUserName()),null,null);
    }

    @Override
    public CollectTruckRefuelVO getReportInfo(Integer id) {

        return collectTruckRefuelDao.getEntityByKey(id).map(collectTruckRefuelStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
    }

    @Override
    public IPage<CollectTruckRefuelVO> pageRefuelReport(PageCollectTruckRefuelParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTruckRefuelDao.pageRefuel(param);
    }

    @Override
    public IPage<CollectTruckRefuelVO> carrierPageRefuelReport(CarrierPageCollectTruckRefuelParam param) {
        return collectTruckRefuelDao.carrierPageRefuel(param);
    }
}
