package com.clx.performance.service.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.collect.CollectTruckLocationDao;
import com.clx.performance.enums.InternalMessageTemplateEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.collect.CollectTruckLocation;
import com.clx.performance.param.app.collect.CollectTruckLocationSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckLocationParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLocationParam;
import com.clx.performance.service.SendInternalMessageService;
import com.clx.performance.service.collect.CollectTruckLocationService;
import com.clx.performance.struct.collect.CollectTruckLocationStruct;
import com.clx.performance.vo.pc.collect.CollectTruckLocationVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class CollectTruckLocationServiceImpl implements CollectTruckLocationService {

    @Autowired
    private CollectTruckLocationDao collectTruckLocationDao;

    @Autowired
    private CollectTruckLocationStruct collectTruckLocationStruct;

    @Autowired
    SendInternalMessageService sendInternalMessageService;


    @Override
    public void saveLocationReport(CollectTruckLocationSaveParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        CollectTruckLocation collectTruckLocation = new CollectTruckLocation();
        collectTruckLocation.setUserNo(userNo);
        collectTruckLocation.setName(loginUserInfo.getUserName());
        collectTruckLocation.setMobile(loginUserInfo.getUserMobile());

        collectTruckLocation.setTruckNo(param.getTruckNo());
        collectTruckLocation.setTruckOrderStatus(param.getTruckOrderStatus());
        collectTruckLocation.setLongitude(param.getLongitude());
        collectTruckLocation.setLatitude(param.getLatitude());
        collectTruckLocation.setProvince(param.getProvince());
        collectTruckLocation.setCity(param.getCity());
        collectTruckLocation.setCounty(param.getCounty());
        collectTruckLocation.setTown(param.getTown());
        collectTruckLocation.setStreet(param.getStreet());
        collectTruckLocation.setAddress(param.getAddress());
        collectTruckLocation.setLocationRemark(param.getLocationRemark());
        collectTruckLocation.setFullAddress("");

        if (!StringUtils.isEmpty(param.getLocationRemark())){
            collectTruckLocation.setFullAddress(param.getLocationRemark());
        }
        else {
            if (!StringUtils.isEmpty(param.getProvince())){collectTruckLocation.setFullAddress(collectTruckLocation.getFullAddress()+param.getProvince());}
            if (!StringUtils.isEmpty(param.getCity())){collectTruckLocation.setFullAddress(collectTruckLocation.getFullAddress()+param.getCity());}
            if (!StringUtils.isEmpty(param.getCounty())){collectTruckLocation.setFullAddress(collectTruckLocation.getFullAddress()+param.getCounty());}
            if (!StringUtils.isEmpty(param.getTown())){collectTruckLocation.setFullAddress(collectTruckLocation.getFullAddress()+param.getTown());}
            if (!StringUtils.isEmpty(param.getStreet())){collectTruckLocation.setFullAddress(collectTruckLocation.getFullAddress()+param.getStreet());}
            if (!StringUtils.isEmpty(param.getAddress())){collectTruckLocation.setFullAddress(collectTruckLocation.getFullAddress()+param.getAddress());}
        }

        collectTruckLocation.setReportTime(LocalDateTime.now());
        collectTruckLocation.setCreateTime(collectTruckLocation.getReportTime());
        collectTruckLocationDao.saveEntity(collectTruckLocation);

        //司机上报：位置 站内信
        sendInternalMessageService.sendInternalMessageMq(InternalMessageTemplateEnum.PlatformType.CARRIER.getCode(),
                InternalMessageTemplateEnum.BusinessType.DRIVER_REPORT.getCode(),
                InternalMessageTemplateEnum.CUSTOM_DRIVER_REPORT_POSITION_CODE, List.of(loginUserInfo.getUserName()),null,null);
    }

    @Override
    public CollectTruckLocationVO getReportInfo(Integer id) {
        return collectTruckLocationDao.getEntityByKey(id).map(collectTruckLocationStruct::convert).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

    }

    @Override
    public IPage<CollectTruckLocationVO> pageLocationReport(PageCollectTruckLocationParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();

        param.setUserNo(userNo);
        return collectTruckLocationDao.pageLocation(param);
    }

    @Override
    public IPage<CollectTruckLocationVO> carrierPageLocationReport(CarrierPageCollectTruckLocationParam param) {
        return collectTruckLocationDao.carrierPageLocation(param);
    }
}
