package com.clx.performance.service.customer.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.customer.CustomerComplaintDetailDao;
import com.clx.performance.dao.customer.CustomerComplaintTypeDao;
import com.clx.performance.enums.InternalMessageTemplateEnum;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.model.customer.CustomerComplaintDetail;
import com.clx.performance.model.customer.CustomerComplaintType;
import com.clx.performance.param.pc.customer.PageCustomerComplaintDetailParam;
import com.clx.performance.param.pc.customer.SaveCustomerComplaintDetailParam;
import com.clx.performance.service.SendInternalMessageService;
import com.clx.performance.service.customer.CustomerComplaintDetailService;
import com.clx.performance.struct.customer.CustomerComplaintDetailStruct;
import com.clx.performance.vo.pc.customer.CustomerComplaintDetailVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @ClassName CustomerComplaintTypeServiceImpl
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:51
 * @Version 1.0
 */
@Slf4j
@Service
@AllArgsConstructor
public class CustomerComplaintDetailServiceImpl implements CustomerComplaintDetailService {
    private final CustomerComplaintDetailDao customerComplaintDetailDao;
    private final CustomerComplaintTypeDao customerComplaintTypeDao;
    private final SendInternalMessageService sendInternalMessageService;

    @Override
    public void saveCustomerComplaintDetail(SaveCustomerComplaintDetailParam param) {
        CustomerComplaintType type = customerComplaintTypeDao.getEntityByKey(
                param.getComplaintTypeId()).orElseThrow(ResultEnum.DATA_NOT_FIND, "投诉类型不存在");
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        CustomerComplaintDetail detail = new CustomerComplaintDetail();
        detail.setDriverUserNo(loginUserInfo.getUserNo());
        detail.setDriverName(loginUserInfo.getUserName());
        detail.setDriverMobile(loginUserInfo.getUserMobile());
        detail.setChildNo(param.getChildNo());
        detail.setComplaintTypeId(param.getComplaintTypeId());
        detail.setContent(param.getContent());
        if(CollectionUtil.isNotEmpty(param.getPicture())){
            detail.setPicture(String.join(",",param.getPicture()));
        }
        customerComplaintDetailDao.saveEntity(detail);

        //客户投诉 站内信
        sendInternalMessageService.sendInternalMessageMq(InternalMessageTemplateEnum.PlatformType.CARRIER.getCode(),
                InternalMessageTemplateEnum.BusinessType.COMPLAINT_NOTICE.getCode(),
                InternalMessageTemplateEnum.CUSTOM_DRIVER_SUBMIT_COMPLAINT_CODE, List.of(param.getChildNo(),type.getName(),param.getContent()),null,null);

    }

    @Override
    public IPage<CustomerComplaintDetailVO> pageCustomerComplaintDetail(PageCustomerComplaintDetailParam param) {
        Page<CustomerComplaintDetailVO> page  = customerComplaintDetailDao.pageCustomerComplaintDetail(param);
        if(CollectionUtil.isNotEmpty(page.getRecords())){
            page.getRecords().forEach(item->{
                if(StringUtils.isNotBlank(item.getPicture())){
                    item.setPictureList(Arrays.asList(item.getPicture().split(",")));
                }
            });
        }
        return page;
    }
}
