package com.clx.performance.model.linewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 线路预警货单表
* @Date: 2024/05/30 13:31:44
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class LineWarnOrderGoods implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String orderGoodsNo;                    //货单编号
    private LocalDateTime transportEndTime;         //拉运结束时间
    private LocalDateTime pendingOrderTime;         //挂单时间
    private Integer arriveReceiveExpectTime;        //预计到达目的地时间 （min）

    private Integer pengNum;                        //挂单数
    private Integer takeNum;                        //接单数
    private Integer arriveSendNum;                  //到达货源地车数
    private Integer loadNum;                        //装车车数
    private Integer arriveReceiveNum;               //到达目的地车数
    private Integer unloadNum;                      //卸车车数
    private LocalDateTime lastLineReportTime;       //上次线路上报时间
    private Integer status;                         //状态
    private Integer warnStatus;                     //预警使能：0禁用 1启用
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}