package com.clx.performance.controller.temp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.open.sdk.callback.message.OrderChildSyncMessage;
import com.clx.performance.dto.OrderChildExpectDTO;
import com.clx.performance.enums.InternalMessageTemplateEnum;
import com.clx.performance.extranal.transport.TransportService;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.listener.OrderChildDtsListener;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.SendInternalMessageService;
import com.clx.performance.service.TempService;
import com.clx.performance.service.child.FeignOrderChildService;
import com.msl.common.result.Result;
import com.msl.common.utils.DateUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@AllArgsConstructor
@RequestMapping(value="/temp/internalMessage")
public class TempInternalMessageController {


    private final SendInternalMessageService sendInternalMessageService;


    @Operation(summary = "发送站内信", description = "<br>By:刘海泉")
    @RequestMapping(value = "/send", method = RequestMethod.GET)
    public Result<Object> send(@RequestParam("businessType") @NotBlank(message = "站内信大类业务不能为空") String businessType,
            @RequestParam("typeCode") @NotNull(message = "业务code不能为空")  Integer  typeCode,
            @RequestParam("listJson") @NotBlank(message = "参数字符串")  String  listJson,
            @RequestParam("jumpParamJson") @NotBlank(message = "跳转参数字符串")  String  jumpParamJson
           ) {
        sendInternalMessageService.sendInternalMessageMq(InternalMessageTemplateEnum.PlatformType.CARRIER.getCode(),
                businessType, typeCode, JSON.parseObject(listJson, new TypeReference<>() {
                }),JSON.parseObject(jumpParamJson, new TypeReference<>() {
                }),null);
        return Result.ok();

    }




}
